/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataframe;

import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.ml.common.dataframe.ColumnType;
import io.skylite.ml.common.dataframe.ColumnValue;
import java.io.IOException;

public class LongValue
implements ColumnValue {
    private final long value;

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public ColumnType columnType() {
        return ColumnType.LONG;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return Long.valueOf(this.value).doubleValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.columnType());
        out.writeLong(this.value);
    }

    public String toString() {
        return "LongValue{value=" + this.value + "}";
    }
}

