/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataset;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.InputDataSet;
import io.skylite.ml.common.dataframe.DataFrame;
import io.skylite.ml.common.dataframe.DataFrameType;
import io.skylite.ml.common.dataframe.DefaultDataFrame;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import java.io.IOException;
import java.util.Objects;

@InputDataSet(value=MLInputDataType.DATA_FRAME)
public class DataFrameInputDataset
extends MLInputDataset {
    private final DataFrame dataFrame;

    public DataFrameInputDataset(DataFrame dataFrame) {
        super(MLInputDataType.DATA_FRAME);
        this.dataFrame = Objects.requireNonNull(dataFrame);
    }

    public DataFrameInputDataset(StreamInput in) throws IOException {
        super(MLInputDataType.DATA_FRAME);
        DataFrameType dataFrameType = (DataFrameType)in.readEnum(DataFrameType.class);
        switch (dataFrameType) {
            case DEFAULT: {
                this.dataFrame = new DefaultDataFrame(in);
                break;
            }
            default: {
                this.dataFrame = null;
            }
        }
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        this.dataFrame.writeTo(streamOutput);
    }

    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Builder {
        private DataFrame dataFrame;

        public Builder dataFrame(DataFrame dataFrame) {
            this.dataFrame = dataFrame;
            return this;
        }

        public DataFrameInputDataset build() {
            return new DataFrameInputDataset(this.dataFrame);
        }
    }
}

