/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataset;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.annotation.InputDataSet;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.output.model.ModelResultFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@InputDataSet(value=MLInputDataType.TEXT_DOCS)
public class TextDocsInputDataSet
extends MLInputDataset {
    private final ModelResultFilter resultFilter;
    private final List<String> docs;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MULTI_MODAL = CommonValue.VERSION_2_11_0;

    public TextDocsInputDataSet(List<String> docs, ModelResultFilter resultFilter) {
        super(MLInputDataType.TEXT_DOCS);
        this.resultFilter = resultFilter;
        Objects.requireNonNull(docs);
        if (docs.size() == 0) {
            throw new IllegalArgumentException("empty docs");
        }
        this.docs = docs;
    }

    public TextDocsInputDataSet(StreamInput streamInput) throws IOException {
        super(MLInputDataType.TEXT_DOCS);
        Version version = streamInput.getVersion();
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_MULTI_MODAL)) {
            this.docs = new ArrayList<String>();
            int size = streamInput.readInt();
            for (int i = 0; i < size; ++i) {
                this.docs.add(streamInput.readOptionalString());
            }
        } else {
            this.docs = streamInput.readStringList();
        }
        this.resultFilter = streamInput.readBoolean() ? new ModelResultFilter(streamInput) : null;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        Version version = streamOutput.getVersion();
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_MULTI_MODAL)) {
            streamOutput.writeInt(this.docs.size());
            for (String doc : this.docs) {
                streamOutput.writeOptionalString(doc);
            }
        } else {
            streamOutput.writeStringCollection(this.docs);
        }
        if (this.resultFilter != null) {
            streamOutput.writeBoolean(true);
            this.resultFilter.writeTo(streamOutput);
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    public ModelResultFilter getResultFilter() {
        return this.resultFilter;
    }

    public List<String> getDocs() {
        return this.docs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().docs(this.docs).resultFilter(this.resultFilter);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Builder {
        private ModelResultFilter resultFilter;
        private List<String> docs;

        public Builder resultFilter(ModelResultFilter resultFilter) {
            this.resultFilter = resultFilter;
            return this;
        }

        public Builder docs(List<String> docs) {
            this.docs = docs;
            return this;
        }

        public TextDocsInputDataSet build() {
            return new TextDocsInputDataSet(this.docs, this.resultFilter);
        }
    }
}

