/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.engine;

import io.skylite.common.SuppressForbidden;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.ConnectorExecutor;
import io.skylite.ml.common.annotation.Function;
import io.skylite.ml.common.annotation.Ingester;
import io.skylite.ml.common.exception.MLException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class MLEngineClassLoader {
    private static final Logger logger = LogManager.getLogger(MLEngineClassLoader.class);
    private static Map<Enum<?>, Class<?>> mlAlgoClassMap = new HashMap();
    private static Map<String, Class<?>> connectorExecutorMap = new HashMap();
    private static Map<String, Class<?>> ingesterMap = new HashMap();
    private static Map<Enum<?>, Object> mlObjects = new HashMap();

    public static synchronized void initializeFromPlugin(ClassLoader pluginClassLoader) {
        if (!mlAlgoClassMap.isEmpty()) {
            return;
        }
        try {
            AccessController.doPrivileged(() -> {
                MLEngineClassLoader.loadClassMapping(pluginClassLoader);
                MLEngineClassLoader.loadIngestClassMapping(pluginClassLoader);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Can't load class mapping in ML engine", e);
        }
    }

    public static void register(Enum<?> functionName, Object obj) {
        mlObjects.put(functionName, obj);
    }

    public static Object deregister(Enum<?> functionName) {
        return mlObjects.remove(functionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadClassMapping(ClassLoader pluginClassLoader) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)Stream.concat(ClasspathHelper.forPackage((String)"io.skylite.ml.common.algorithms", (ClassLoader[])new ClassLoader[0]).stream(), ClasspathHelper.forPackage((String)"io.lucenia.ml.common.engine.algorithms", (ClassLoader[])new ClassLoader[0]).stream()).collect(Collectors.toList())).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()}));
            Set classes = reflections.getTypesAnnotatedWith(Function.class);
            for (Class clazz : classes) {
                Function function = clazz.getAnnotation(Function.class);
                FunctionName functionName = function.value();
                if (functionName == null) continue;
                mlAlgoClassMap.put(functionName, clazz);
            }
            Set connectorExecutorClasses = reflections.getTypesAnnotatedWith(ConnectorExecutor.class);
            for (Class clazz : connectorExecutorClasses) {
                ConnectorExecutor connectorExecutor = clazz.getAnnotation(ConnectorExecutor.class);
                String connectorName = connectorExecutor.value();
                if (connectorName == null) continue;
                connectorExecutorMap.put(connectorName, clazz);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadIngestClassMapping(ClassLoader pluginClassLoader) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)Stream.concat(ClasspathHelper.forPackage((String)"io.skylite.ml.common.engine.ingest", (ClassLoader[])new ClassLoader[0]).stream(), ClasspathHelper.forPackage((String)"io.lucenia.ml.common.engine.ingest", (ClassLoader[])new ClassLoader[0]).stream()).collect(Collectors.toList())).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()}));
            Set ingesterClasses = reflections.getTypesAnnotatedWith(Ingester.class);
            for (Class clazz : ingesterClasses) {
                Ingester ingester = clazz.getAnnotation(Ingester.class);
                String ingesterSource = ingester.value();
                if (ingesterSource == null) continue;
                ingesterMap.put(ingesterSource, clazz);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static <T, S, I> S initInstance(T type, I in, Class<?> constructorParamClass) {
        return MLEngineClassLoader.initInstance(type, in, constructorParamClass, null);
    }

    public static <T, S, I> S initInstance(T type, I in, Class<?> constructorParamClass, Map<String, Object> properties) {
        if (mlObjects.containsKey(type)) {
            return (S)mlObjects.get(type);
        }
        Class<?> clazz = mlAlgoClassMap.get(type);
        if (clazz == null) {
            clazz = connectorExecutorMap.get(type);
        }
        if (clazz == null) {
            clazz = ingesterMap.get(type);
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Can't find class for type " + String.valueOf(type));
        }
        try {
            Object instance;
            try {
                Constructor<?> constructor = clazz.getConstructor(constructorParamClass);
                instance = constructor.newInstance(in);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            if (properties != null) {
                MLEngineClassLoader.setProperties(instance, properties);
            }
            return (S)instance;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof MLException) {
                throw (MLException)cause;
            }
            logger.error("Failed to init instance for type " + String.valueOf(type), (Throwable)e);
            return null;
        }
    }

    @SuppressForbidden(reason="needed for ML Classloading")
    private static void setProperties(Object instance, Map<String, Object> properties) {
        Class<?> clazz = instance.getClass();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            Object value = entry.getValue();
            try {
                Field field = clazz.getDeclaredField(propertyName);
                field.setAccessible(true);
                field.set(instance, value);
            }
            catch (NoSuchFieldException fieldException) {
                String setterMethodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                try {
                    Method setterMethod = MLEngineClassLoader.findSetter(clazz, setterMethodName, value);
                    if (setterMethod != null) {
                        setterMethod.invoke(instance, value);
                        continue;
                    }
                    logger.warn("No field or setter found for property: " + propertyName + " in class " + clazz.getName());
                }
                catch (IllegalAccessException | InvocationTargetException methodException) {
                    logger.error("Unable to set property: " + propertyName + " in class " + clazz.getName(), (Throwable)methodException);
                }
            }
            catch (IllegalAccessException fieldAccessException) {
                logger.error("Unable to set field: " + propertyName + " in class " + clazz.getName(), (Throwable)fieldAccessException);
            }
        }
    }

    private static Method findSetter(Class<?> clazz, String setterName, Object value) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(setterName) || method.getParameterCount() != 1) continue;
            Class<?> paramType = method.getParameterTypes()[0];
            if (value != null && !paramType.isAssignableFrom(value.getClass())) continue;
            return method;
        }
        return null;
    }
}

