/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.execute.samplecalculator;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.ExecuteInput;
import io.skylite.ml.common.input.Input;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ExecuteInput(algorithms={FunctionName.LOCAL_SAMPLE_CALCULATOR})
public class LocalSampleCalculatorInput
implements Input {
    public static final String PARSE_FIELD_NAME = FunctionName.LOCAL_SAMPLE_CALCULATOR.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> LocalSampleCalculatorInput.parse(it));
    public static final String OPERATION_FIELD = "operation";
    public static final String INPUT_DATA_FIELD = "input_data";
    private String operation;
    private List<Double> inputData;

    public LocalSampleCalculatorInput(String operation, List<Double> inputData) {
        if (operation == null) {
            throw new IllegalArgumentException("wrong operation");
        }
        if (inputData == null || inputData.size() == 0) {
            throw new IllegalArgumentException("empty input data");
        }
        this.operation = operation;
        this.inputData = inputData;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public List<Double> getInputData() {
        return this.inputData;
    }

    public void setInputData(List<Double> inputData) {
        this.inputData = inputData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LocalSampleCalculatorInput parse(XContentParser parser) throws IOException {
        String operation = null;
        ArrayList<Double> inputData = new ArrayList<Double>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "operation": {
                    operation = parser.text();
                    continue block8;
                }
                case "input_data": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        inputData.add(parser.doubleValue(false));
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new LocalSampleCalculatorInput(operation, inputData);
    }

    @Override
    public FunctionName getFunctionName() {
        return FunctionName.LOCAL_SAMPLE_CALCULATOR;
    }

    public LocalSampleCalculatorInput(StreamInput in) throws IOException {
        this.operation = in.readString();
        int size = in.readInt();
        this.inputData = new ArrayList<Double>();
        for (int i = 0; i < size; ++i) {
            this.inputData.add(in.readDouble());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.operation);
        out.writeInt(this.inputData.size());
        for (Double d : this.inputData) {
            out.writeDouble(d.doubleValue());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(OPERATION_FIELD, this.operation);
        builder.field(INPUT_DATA_FIELD, this.inputData);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalSampleCalculatorInput that = (LocalSampleCalculatorInput)o;
        return Objects.equals(this.operation, that.operation) && Objects.equals(this.inputData, that.inputData);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.inputData);
    }

    public String toString() {
        return "LocalSampleCalculatorInput{operation='" + this.operation + "', inputData=" + String.valueOf(this.inputData) + "}";
    }

    public static class Builder {
        private String operation;
        private List<Double> inputData;

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder inputData(List<Double> inputData) {
            this.inputData = inputData;
            return this;
        }

        public LocalSampleCalculatorInput build() {
            return new LocalSampleCalculatorInput(this.operation, this.inputData);
        }
    }
}

