/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.parameter.ad;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.MLAlgoParameter;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

@MLAlgoParameter(algorithms={FunctionName.AD_LIBSVM})
public class AnomalyDetectionLibSVMParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.AD_LIBSVM.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> AnomalyDetectionLibSVMParams.parse(it));
    public static final String KERNEL_FIELD = "kernel";
    public static final String GAMMA_FIELD = "gamma";
    public static final String NU_FIELD = "nu";
    public static final String COST_FIELD = "cost";
    public static final String COEFF_FIELD = "coeff";
    public static final String EPSILON_FIELD = "epsilon";
    public static final String DEGREE_FIELD = "degree";
    private ADKernelType kernelType;
    private Double gamma;
    private Double nu;
    private Double cost;
    private Double coeff;
    private Double epsilon;
    private Integer degree;

    public AnomalyDetectionLibSVMParams(ADKernelType kernelType, Double gamma, Double nu, Double cost, Double coeff, Double epsilon, Integer degree) {
        this.kernelType = kernelType;
        this.gamma = gamma;
        this.nu = nu;
        this.cost = cost;
        this.coeff = coeff;
        this.epsilon = epsilon;
        this.degree = degree;
    }

    public ADKernelType getKernelType() {
        return this.kernelType;
    }

    public void setKernelType(ADKernelType kernelType) {
        this.kernelType = kernelType;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public void setGamma(Double gamma) {
        this.gamma = gamma;
    }

    public Double getNu() {
        return this.nu;
    }

    public void setNu(Double nu) {
        this.nu = nu;
    }

    public Double getCost() {
        return this.cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public Double getCoeff() {
        return this.coeff;
    }

    public void setCoeff(Double coeff) {
        this.coeff = coeff;
    }

    public Double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(Double epsilon) {
        this.epsilon = epsilon;
    }

    public Integer getDegree() {
        return this.degree;
    }

    public void setDegree(Integer degree) {
        this.degree = degree;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().kernelType(this.kernelType).gamma(this.gamma).nu(this.nu).cost(this.cost).coeff(this.coeff).epsilon(this.epsilon).degree(this.degree);
    }

    public AnomalyDetectionLibSVMParams(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.kernelType = (ADKernelType)in.readEnum(ADKernelType.class);
        }
        this.gamma = in.readOptionalDouble();
        this.nu = in.readOptionalDouble();
        this.cost = in.readOptionalDouble();
        this.coeff = in.readOptionalDouble();
        this.epsilon = in.readOptionalDouble();
        this.degree = in.readOptionalInt();
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        ADKernelType kernelType = null;
        Double gamma = null;
        Double nu = null;
        Double cost = null;
        Double coeff = null;
        Double epsilon = null;
        Integer degree = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "kernel": {
                    kernelType = ADKernelType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block18;
                }
                case "gamma": {
                    gamma = parser.doubleValue(false);
                    continue block18;
                }
                case "nu": {
                    nu = parser.doubleValue(false);
                    continue block18;
                }
                case "cost": {
                    cost = parser.doubleValue(false);
                    continue block18;
                }
                case "coeff": {
                    coeff = parser.doubleValue(false);
                    continue block18;
                }
                case "epsilon": {
                    epsilon = parser.doubleValue(false);
                    continue block18;
                }
                case "degree": {
                    degree = parser.intValue(false);
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return new AnomalyDetectionLibSVMParams(kernelType, gamma, nu, cost, coeff, epsilon, degree);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.kernelType == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.kernelType);
        }
        out.writeOptionalDouble(this.gamma);
        out.writeOptionalDouble(this.nu);
        out.writeOptionalDouble(this.cost);
        out.writeOptionalDouble(this.coeff);
        out.writeOptionalDouble(this.epsilon);
        out.writeOptionalInt(this.degree);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.kernelType != null) {
            builder.field(KERNEL_FIELD, (Object)this.kernelType);
        }
        if (this.gamma != null) {
            builder.field(GAMMA_FIELD, this.gamma);
        }
        if (this.nu != null) {
            builder.field(NU_FIELD, this.nu);
        }
        if (this.cost != null) {
            builder.field(COST_FIELD, this.cost);
        }
        if (this.coeff != null) {
            builder.field(COEFF_FIELD, this.coeff);
        }
        if (this.epsilon != null) {
            builder.field(EPSILON_FIELD, this.epsilon);
        }
        if (this.degree != null) {
            builder.field(DEGREE_FIELD, this.degree);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyDetectionLibSVMParams that = (AnomalyDetectionLibSVMParams)o;
        return this.kernelType == that.kernelType && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.nu, that.nu) && Objects.equals(this.cost, that.cost) && Objects.equals(this.coeff, that.coeff) && Objects.equals(this.epsilon, that.epsilon) && Objects.equals(this.degree, that.degree);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kernelType, this.gamma, this.nu, this.cost, this.coeff, this.epsilon, this.degree});
    }

    public String toString() {
        return "AnomalyDetectionLibSVMParams{kernelType=" + String.valueOf((Object)this.kernelType) + ", gamma=" + this.gamma + ", nu=" + this.nu + ", cost=" + this.cost + ", coeff=" + this.coeff + ", epsilon=" + this.epsilon + ", degree=" + this.degree + "}";
    }

    public static enum ADKernelType {
        LINEAR,
        POLY,
        RBF,
        SIGMOID;


        public static ADKernelType from(String value) {
            try {
                return ADKernelType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong AD kernel type");
            }
        }
    }

    public static class Builder {
        private ADKernelType kernelType;
        private Double gamma;
        private Double nu;
        private Double cost;
        private Double coeff;
        private Double epsilon;
        private Integer degree;

        public Builder kernelType(ADKernelType kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        public Builder gamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder nu(Double nu) {
            this.nu = nu;
            return this;
        }

        public Builder cost(Double cost) {
            this.cost = cost;
            return this;
        }

        public Builder coeff(Double coeff) {
            this.coeff = coeff;
            return this;
        }

        public Builder epsilon(Double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Builder degree(Integer degree) {
            this.degree = degree;
            return this;
        }

        public AnomalyDetectionLibSVMParams build() {
            return new AnomalyDetectionLibSVMParams(this.kernelType, this.gamma, this.nu, this.cost, this.coeff, this.epsilon, this.degree);
        }
    }
}

