/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.parameter.clustering;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.MLAlgoParameter;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Objects;

@MLAlgoParameter(algorithms={FunctionName.KMEANS})
public class KMeansParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.KMEANS.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> KMeansParams.parse(it));
    public static final String CENTROIDS_FIELD = "centroids";
    public static final String ITERATIONS_FIELD = "iterations";
    public static final String DISTANCE_TYPE_FIELD = "distance_type";
    private Integer centroids;
    private Integer iterations;
    private DistanceType distanceType;

    public KMeansParams(Integer centroids, Integer iterations, DistanceType distanceType) {
        this.centroids = centroids;
        this.iterations = iterations;
        this.distanceType = distanceType;
    }

    public KMeansParams(StreamInput in) throws IOException {
        this.centroids = in.readOptionalInt();
        this.iterations = in.readOptionalInt();
        if (in.readBoolean()) {
            this.distanceType = (DistanceType)in.readEnum(DistanceType.class);
        }
    }

    public Integer getCentroids() {
        return this.centroids;
    }

    public void setCentroids(Integer centroids) {
        this.centroids = centroids;
    }

    public Integer getIterations() {
        return this.iterations;
    }

    public void setIterations(Integer iterations) {
        this.iterations = iterations;
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().centroids(this.centroids).iterations(this.iterations).distanceType(this.distanceType);
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        Integer k = null;
        Integer iterations = null;
        DistanceType distanceType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "centroids": {
                    k = parser.intValue(false);
                    continue block10;
                }
                case "iterations": {
                    iterations = parser.intValue(false);
                    continue block10;
                }
                case "distance_type": {
                    distanceType = DistanceType.from(parser.text());
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new KMeansParams(k, iterations, distanceType);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.centroids);
        out.writeOptionalInt(this.iterations);
        if (this.distanceType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.distanceType);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.centroids != null) {
            builder.field(CENTROIDS_FIELD, this.centroids);
        }
        if (this.iterations != null) {
            builder.field(ITERATIONS_FIELD, this.iterations);
        }
        if (this.distanceType != null) {
            builder.field(DISTANCE_TYPE_FIELD, this.distanceType.name());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String toString() {
        return "KMeansParams{centroids=" + this.centroids + ", iterations=" + this.iterations + ", distanceType=" + String.valueOf((Object)this.distanceType) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KMeansParams that = (KMeansParams)o;
        return Objects.equals(this.centroids, that.centroids) && Objects.equals(this.iterations, that.iterations) && this.distanceType == that.distanceType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.centroids, this.iterations, this.distanceType});
    }

    public static enum DistanceType {
        EUCLIDEAN,
        COSINE,
        L1;


        public static DistanceType from(String value) {
            try {
                return DistanceType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong distance type");
            }
        }
    }

    public static class Builder {
        private Integer centroids;
        private Integer iterations;
        private DistanceType distanceType;

        public Builder centroids(Integer centroids) {
            this.centroids = centroids;
            return this;
        }

        public Builder iterations(Integer iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder distanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        public KMeansParams build() {
            return new KMeansParams(this.centroids, this.iterations, this.distanceType);
        }
    }
}

