/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.parameter.clustering;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.MLAlgoParameter;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

@MLAlgoParameter(algorithms={FunctionName.RCF_SUMMARIZE})
public class RCFSummarizeParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.RCF_SUMMARIZE.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> RCFSummarizeParams.parse(it));
    public static final String MAX_K_FIELD = "max_k";
    public static final String INITIAL_K_FIELD = "initial_k";
    public static final String DISTANCE_TYPE_FIELD = "distance_type";
    public static final String PHASE1_REASSIGN_FIELD = "phase1_reassign";
    public static final String PARALLEL__FIELD = "parallel";
    private Integer maxK;
    private Integer initialK;
    private DistanceType distanceType;
    private Boolean phase1Reassign;
    private Boolean parallel;

    public RCFSummarizeParams(Integer maxK, Integer initialK, DistanceType distanceType, Boolean phase1Reassign, Boolean parallel) {
        this.maxK = maxK;
        this.initialK = initialK;
        this.distanceType = distanceType;
        this.phase1Reassign = phase1Reassign;
        this.parallel = parallel;
    }

    public RCFSummarizeParams(StreamInput in) throws IOException {
        this.maxK = in.readOptionalInt();
        this.initialK = in.readOptionalInt();
        this.phase1Reassign = in.readOptionalBoolean();
        this.parallel = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.distanceType = (DistanceType)in.readEnum(DistanceType.class);
        }
    }

    public Integer getMaxK() {
        return this.maxK;
    }

    public void setMaxK(Integer maxK) {
        this.maxK = maxK;
    }

    public Integer getInitialK() {
        return this.initialK;
    }

    public void setInitialK(Integer initialK) {
        this.initialK = initialK;
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    public Boolean getPhase1Reassign() {
        return this.phase1Reassign;
    }

    public void setPhase1Reassign(Boolean phase1Reassign) {
        this.phase1Reassign = phase1Reassign;
    }

    public Boolean getParallel() {
        return this.parallel;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().maxK(this.maxK).initialK(this.initialK).distanceType(this.distanceType).phase1Reassign(this.phase1Reassign).parallel(this.parallel);
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        Integer maxK = null;
        Integer initialK = null;
        Boolean phase1Reassign = null;
        Boolean parallel = null;
        DistanceType distanceType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "max_k": {
                    maxK = parser.intValue(false);
                    continue block14;
                }
                case "initial_k": {
                    initialK = parser.intValue(false);
                    continue block14;
                }
                case "phase1_reassign": {
                    phase1Reassign = parser.booleanValue();
                    continue block14;
                }
                case "parallel": {
                    parallel = parser.booleanValue();
                    continue block14;
                }
                case "distance_type": {
                    distanceType = DistanceType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return new RCFSummarizeParams(maxK, initialK, distanceType, phase1Reassign, parallel);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.maxK);
        out.writeOptionalInt(this.initialK);
        out.writeOptionalBoolean(this.phase1Reassign);
        out.writeOptionalBoolean(this.parallel);
        if (this.distanceType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.distanceType);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxK != null) {
            builder.field(MAX_K_FIELD, this.maxK);
        }
        if (this.initialK != null) {
            builder.field(INITIAL_K_FIELD, this.initialK);
        }
        if (this.phase1Reassign != null) {
            builder.field(PHASE1_REASSIGN_FIELD, this.phase1Reassign);
        }
        if (this.parallel != null) {
            builder.field(PARALLEL__FIELD, this.parallel);
        }
        if (this.distanceType != null) {
            builder.field(DISTANCE_TYPE_FIELD, this.distanceType.name());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String toString() {
        return "RCFSummarizeParams{maxK=" + this.maxK + ", initialK=" + this.initialK + ", distanceType=" + String.valueOf((Object)this.distanceType) + ", phase1Reassign=" + this.phase1Reassign + ", parallel=" + this.parallel + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RCFSummarizeParams that = (RCFSummarizeParams)o;
        return Objects.equals(this.maxK, that.maxK) && Objects.equals(this.initialK, that.initialK) && this.distanceType == that.distanceType && Objects.equals(this.phase1Reassign, that.phase1Reassign) && Objects.equals(this.parallel, that.parallel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxK, this.initialK, this.distanceType, this.phase1Reassign, this.parallel});
    }

    public static enum DistanceType {
        L1,
        L2,
        LInfinity;


        public static DistanceType from(String value) {
            try {
                return DistanceType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong distance type");
            }
        }
    }

    public static class Builder {
        private Integer maxK;
        private Integer initialK;
        private DistanceType distanceType;
        private Boolean phase1Reassign;
        private Boolean parallel;

        public RCFSummarizeParams build() {
            return new RCFSummarizeParams(this.maxK, this.initialK, this.distanceType, this.phase1Reassign, this.parallel);
        }

        public Builder maxK(Integer maxK) {
            this.maxK = maxK;
            return this;
        }

        public Builder initialK(Integer initialK) {
            this.initialK = initialK;
            return this;
        }

        public Builder distanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        public Builder phase1Reassign(Boolean phase1Reassign) {
            this.phase1Reassign = phase1Reassign;
            return this;
        }

        public Builder parallel(Boolean parallel) {
            this.parallel = parallel;
            return this;
        }
    }
}

