/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.parameter.rcf;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.MLAlgoParameter;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Objects;

@MLAlgoParameter(algorithms={FunctionName.BATCH_RCF})
public class BatchRCFParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.BATCH_RCF.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> BatchRCFParams.parse(it));
    public static final String NUMBER_OF_TREES = "number_of_trees";
    public static final String SHINGLE_SIZE = "shingle_size";
    public static final String SAMPLE_SIZE = "sample_size";
    public static final String OUTPUT_AFTER = "output_after";
    public static final String TRAINING_DATA_SIZE = "training_data_size";
    public static final String ANOMALY_SCORE_THRESHOLD = "anomaly_score_threshold";
    private Integer numberOfTrees;
    private Integer shingleSize;
    private Integer sampleSize;
    private Integer outputAfter;
    private Integer trainingDataSize;
    private Double anomalyScoreThreshold;

    public BatchRCFParams(Integer numberOfTrees, Integer shingleSize, Integer sampleSize, Integer outputAfter, Integer trainingDataSize, Double anomalyScoreThreshold) {
        this.numberOfTrees = numberOfTrees;
        this.shingleSize = shingleSize;
        this.sampleSize = sampleSize;
        this.outputAfter = outputAfter;
        this.trainingDataSize = trainingDataSize;
        this.anomalyScoreThreshold = anomalyScoreThreshold;
    }

    public BatchRCFParams(StreamInput in) throws IOException {
        this.numberOfTrees = in.readOptionalInt();
        this.shingleSize = in.readOptionalInt();
        this.sampleSize = in.readOptionalInt();
        this.outputAfter = in.readOptionalInt();
        this.trainingDataSize = in.readOptionalInt();
        this.anomalyScoreThreshold = in.readOptionalDouble();
    }

    public Integer getNumberOfTrees() {
        return this.numberOfTrees;
    }

    public void setNumberOfTrees(Integer numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }

    public Integer getShingleSize() {
        return this.shingleSize;
    }

    public void setShingleSize(Integer shingleSize) {
        this.shingleSize = shingleSize;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Integer getOutputAfter() {
        return this.outputAfter;
    }

    public void setOutputAfter(Integer outputAfter) {
        this.outputAfter = outputAfter;
    }

    public Integer getTrainingDataSize() {
        return this.trainingDataSize;
    }

    public void setTrainingDataSize(Integer trainingDataSize) {
        this.trainingDataSize = trainingDataSize;
    }

    public Double getAnomalyScoreThreshold() {
        return this.anomalyScoreThreshold;
    }

    public void setAnomalyScoreThreshold(Double anomalyScoreThreshold) {
        this.anomalyScoreThreshold = anomalyScoreThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.numberOfTrees);
        out.writeOptionalInt(this.shingleSize);
        out.writeOptionalInt(this.sampleSize);
        out.writeOptionalInt(this.outputAfter);
        out.writeOptionalInt(this.trainingDataSize);
        out.writeOptionalDouble(this.anomalyScoreThreshold);
    }

    public static BatchRCFParams parse(XContentParser parser) throws IOException {
        Integer numberOfTrees = null;
        Integer shingleSize = null;
        Integer sampleSize = null;
        Integer outputAfter = null;
        Integer trainingDataSize = null;
        Double anomalyScoreThreshold = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "number_of_trees": {
                    numberOfTrees = parser.intValue(false);
                    continue block16;
                }
                case "shingle_size": {
                    shingleSize = parser.intValue(false);
                    continue block16;
                }
                case "sample_size": {
                    sampleSize = parser.intValue(false);
                    continue block16;
                }
                case "output_after": {
                    outputAfter = parser.intValue(false);
                    continue block16;
                }
                case "training_data_size": {
                    trainingDataSize = parser.intValue(false);
                    continue block16;
                }
                case "anomaly_score_threshold": {
                    anomalyScoreThreshold = parser.doubleValue(false);
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new BatchRCFParams(numberOfTrees, shingleSize, sampleSize, outputAfter, trainingDataSize, anomalyScoreThreshold);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfTrees != null) {
            builder.field(NUMBER_OF_TREES, this.numberOfTrees);
        }
        if (this.shingleSize != null) {
            builder.field(SHINGLE_SIZE, this.shingleSize);
        }
        if (this.sampleSize != null) {
            builder.field(SAMPLE_SIZE, this.sampleSize);
        }
        if (this.outputAfter != null) {
            builder.field(OUTPUT_AFTER, this.outputAfter);
        }
        if (this.trainingDataSize != null) {
            builder.field(TRAINING_DATA_SIZE, this.trainingDataSize);
        }
        if (this.anomalyScoreThreshold != null) {
            builder.field(ANOMALY_SCORE_THRESHOLD, this.anomalyScoreThreshold);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "BatchRCFParams{numberOfTrees=" + this.numberOfTrees + ", shingleSize=" + this.shingleSize + ", sampleSize=" + this.sampleSize + ", outputAfter=" + this.outputAfter + ", trainingDataSize=" + this.trainingDataSize + ", anomalyScoreThreshold=" + this.anomalyScoreThreshold + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRCFParams that = (BatchRCFParams)o;
        return Objects.equals(this.numberOfTrees, that.numberOfTrees) && Objects.equals(this.shingleSize, that.shingleSize) && Objects.equals(this.sampleSize, that.sampleSize) && Objects.equals(this.outputAfter, that.outputAfter) && Objects.equals(this.trainingDataSize, that.trainingDataSize) && Objects.equals(this.anomalyScoreThreshold, that.anomalyScoreThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfTrees, this.shingleSize, this.sampleSize, this.outputAfter, this.trainingDataSize, this.anomalyScoreThreshold);
    }

    public static class Builder {
        private Integer numberOfTrees;
        private Integer shingleSize;
        private Integer sampleSize;
        private Integer outputAfter;
        private Integer trainingDataSize;
        private Double anomalyScoreThreshold;

        public BatchRCFParams build() {
            return new BatchRCFParams(this.numberOfTrees, this.shingleSize, this.sampleSize, this.outputAfter, this.trainingDataSize, this.anomalyScoreThreshold);
        }

        public Builder numberOfTrees(Integer numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return this;
        }

        public Builder shingleSize(Integer shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        public Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public Builder outputAfter(Integer outputAfter) {
            this.outputAfter = outputAfter;
            return this;
        }

        public Builder trainingDataSize(Integer trainingDataSize) {
            this.trainingDataSize = trainingDataSize;
            return this;
        }

        public Builder anomalyScoreThreshold(Double anomalyScoreThreshold) {
            this.anomalyScoreThreshold = anomalyScoreThreshold;
            return this;
        }
    }
}

