/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.parameter.rcf;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.MLAlgoParameter;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Objects;

@MLAlgoParameter(algorithms={FunctionName.FIT_RCF})
public class FitRCFParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.FIT_RCF.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> FitRCFParams.parse(it));
    public static final String NUMBER_OF_TREES = "number_of_trees";
    public static final String SHINGLE_SIZE = "shingle_size";
    public static final String SAMPLE_SIZE = "sample_size";
    public static final String OUTPUT_AFTER = "output_after";
    public static final String TIME_DECAY = "time_decay";
    public static final String ANOMALY_RATE = "anomaly_rate";
    public static final String TIME_FIELD = "time_field";
    public static final String DATE_FORMAT = "date_format";
    public static final String TIME_ZONE = "time_zone";
    private Integer numberOfTrees;
    private Integer shingleSize;
    private Integer sampleSize;
    private Integer outputAfter;
    private Double timeDecay;
    private Double anomalyRate;
    private String timeField;
    private String dateFormat;
    private String timeZone;

    public FitRCFParams(Integer numberOfTrees, Integer shingleSize, Integer sampleSize, Integer outputAfter, Double timeDecay, Double anomalyRate, String timeField, String dateFormat, String timeZone) {
        this.numberOfTrees = numberOfTrees;
        this.shingleSize = shingleSize;
        this.sampleSize = sampleSize;
        this.outputAfter = outputAfter;
        this.timeDecay = timeDecay;
        this.anomalyRate = anomalyRate;
        this.timeField = timeField;
        this.dateFormat = dateFormat;
        this.timeZone = timeZone;
    }

    public FitRCFParams(StreamInput in) throws IOException {
        this.numberOfTrees = in.readOptionalInt();
        this.shingleSize = in.readOptionalInt();
        this.sampleSize = in.readOptionalInt();
        this.outputAfter = in.readOptionalInt();
        this.timeDecay = in.readOptionalDouble();
        this.anomalyRate = in.readOptionalDouble();
        this.timeField = in.readOptionalString();
        this.dateFormat = in.readOptionalString();
        this.timeZone = in.readOptionalString();
    }

    public Integer getNumberOfTrees() {
        return this.numberOfTrees;
    }

    public void setNumberOfTrees(Integer numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }

    public Integer getShingleSize() {
        return this.shingleSize;
    }

    public void setShingleSize(Integer shingleSize) {
        this.shingleSize = shingleSize;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Integer getOutputAfter() {
        return this.outputAfter;
    }

    public void setOutputAfter(Integer outputAfter) {
        this.outputAfter = outputAfter;
    }

    public Double getTimeDecay() {
        return this.timeDecay;
    }

    public void setTimeDecay(Double timeDecay) {
        this.timeDecay = timeDecay;
    }

    public Double getAnomalyRate() {
        return this.anomalyRate;
    }

    public void setAnomalyRate(Double anomalyRate) {
        this.anomalyRate = anomalyRate;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.numberOfTrees);
        out.writeOptionalInt(this.shingleSize);
        out.writeOptionalInt(this.sampleSize);
        out.writeOptionalInt(this.outputAfter);
        out.writeOptionalDouble(this.timeDecay);
        out.writeOptionalDouble(this.anomalyRate);
        out.writeOptionalString(this.timeField);
        out.writeOptionalString(this.dateFormat);
        out.writeOptionalString(this.timeZone);
    }

    public static FitRCFParams parse(XContentParser parser) throws IOException {
        Integer numberOfTrees = null;
        Integer shingleSize = null;
        Integer sampleSize = null;
        Integer outputAfter = null;
        Double timeDecay = null;
        Double anomalyRate = null;
        String timeField = null;
        String dateFormat = null;
        String timeZone = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block22: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "number_of_trees": {
                    numberOfTrees = parser.intValue(false);
                    continue block22;
                }
                case "shingle_size": {
                    shingleSize = parser.intValue(false);
                    continue block22;
                }
                case "sample_size": {
                    sampleSize = parser.intValue(false);
                    continue block22;
                }
                case "output_after": {
                    outputAfter = parser.intValue(false);
                    continue block22;
                }
                case "time_decay": {
                    timeDecay = parser.doubleValue(false);
                    continue block22;
                }
                case "anomaly_rate": {
                    anomalyRate = parser.doubleValue(false);
                    continue block22;
                }
                case "time_field": {
                    timeField = parser.text();
                    continue block22;
                }
                case "date_format": {
                    dateFormat = parser.text();
                    continue block22;
                }
                case "time_zone": {
                    timeZone = parser.text();
                    continue block22;
                }
            }
            parser.skipChildren();
        }
        return new FitRCFParams(numberOfTrees, shingleSize, sampleSize, outputAfter, timeDecay, anomalyRate, timeField, dateFormat, timeZone);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfTrees != null) {
            builder.field(NUMBER_OF_TREES, this.numberOfTrees);
        }
        if (this.shingleSize != null) {
            builder.field(SHINGLE_SIZE, this.shingleSize);
        }
        if (this.sampleSize != null) {
            builder.field(SAMPLE_SIZE, this.sampleSize);
        }
        if (this.outputAfter != null) {
            builder.field(OUTPUT_AFTER, this.outputAfter);
        }
        if (this.timeDecay != null) {
            builder.field(TIME_DECAY, this.timeDecay);
        }
        if (this.anomalyRate != null) {
            builder.field(ANOMALY_RATE, this.anomalyRate);
        }
        if (this.timeField != null) {
            builder.field(TIME_FIELD, this.timeField);
        }
        if (this.dateFormat != null) {
            builder.field(DATE_FORMAT, this.dateFormat);
        }
        if (this.timeZone != null) {
            builder.field(TIME_ZONE, this.timeZone);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "FitRCFParams{numberOfTrees=" + this.numberOfTrees + ", shingleSize=" + this.shingleSize + ", sampleSize=" + this.sampleSize + ", outputAfter=" + this.outputAfter + ", timeDecay=" + this.timeDecay + ", anomalyRate=" + this.anomalyRate + ", timeField='" + this.timeField + "', dateFormat='" + this.dateFormat + "', timeZone='" + this.timeZone + "'}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FitRCFParams that = (FitRCFParams)o;
        return Objects.equals(this.numberOfTrees, that.numberOfTrees) && Objects.equals(this.shingleSize, that.shingleSize) && Objects.equals(this.sampleSize, that.sampleSize) && Objects.equals(this.outputAfter, that.outputAfter) && Objects.equals(this.timeDecay, that.timeDecay) && Objects.equals(this.anomalyRate, that.anomalyRate) && Objects.equals(this.timeField, that.timeField) && Objects.equals(this.dateFormat, that.dateFormat) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfTrees, this.shingleSize, this.sampleSize, this.outputAfter, this.timeDecay, this.anomalyRate, this.timeField, this.dateFormat, this.timeZone);
    }

    public static class Builder {
        private Integer numberOfTrees;
        private Integer shingleSize;
        private Integer sampleSize;
        private Integer outputAfter;
        private Double timeDecay;
        private Double anomalyRate;
        private String timeField;
        private String dateFormat;
        private String timeZone;

        public FitRCFParams build() {
            return new FitRCFParams(this.numberOfTrees, this.shingleSize, this.sampleSize, this.outputAfter, this.timeDecay, this.anomalyRate, this.timeField, this.dateFormat, this.timeZone);
        }

        public Builder numberOfTrees(Integer numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return this;
        }

        public Builder shingleSize(Integer shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        public Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public Builder outputAfter(Integer outputAfter) {
            this.outputAfter = outputAfter;
            return this;
        }

        public Builder timeDecay(Double timeDecay) {
            this.timeDecay = timeDecay;
            return this;
        }

        public Builder anomalyRate(Double anomalyRate) {
            this.anomalyRate = anomalyRate;
            return this;
        }

        public Builder timeField(String timeField) {
            this.timeField = timeField;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }
    }
}

