/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.model;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import java.io.IOException;

public class MLDeploySetting
implements ToXContentObject,
Writeable {
    public static final String IS_AUTO_DEPLOY_ENABLED_FIELD = "is_auto_deploy_enabled";
    public static final String MODEL_TTL_MINUTES_FIELD = "model_ttl_minutes";
    private static final long DEFAULT_TTL_MINUTES = -1L;
    public static final OpenSearchVersion MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL = CommonValue.VERSION_2_14_0;
    private Boolean isAutoDeployEnabled;
    private Long modelTTLInMinutes;

    public MLDeploySetting(Boolean isAutoDeployEnabled, Long modelTTLInMinutes) {
        this.isAutoDeployEnabled = isAutoDeployEnabled;
        this.modelTTLInMinutes = modelTTLInMinutes;
        if (modelTTLInMinutes == null) {
            this.modelTTLInMinutes = -1L;
        }
    }

    public MLDeploySetting(StreamInput in) throws IOException {
        this.isAutoDeployEnabled = in.readOptionalBoolean();
        Version streamInputVersion = in.getVersion();
        if (streamInputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            this.modelTTLInMinutes = in.readOptionalLong();
        }
    }

    public boolean getIsAutoDeployEnabled() {
        return this.isAutoDeployEnabled;
    }

    public MLDeploySetting autoDeployEnabled(boolean autoDeployEnabled) {
        this.isAutoDeployEnabled = autoDeployEnabled;
        return this;
    }

    public long getModelTTLInMinutes() {
        return this.modelTTLInMinutes;
    }

    public MLDeploySetting modelTTLInMinutes(long modelTTLInMinutes) {
        this.modelTTLInMinutes = modelTTLInMinutes;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalBoolean(this.isAutoDeployEnabled);
        if (streamOutputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            out.writeOptionalLong(this.modelTTLInMinutes);
        }
    }

    public static MLDeploySetting parse(XContentParser parser) throws IOException {
        Boolean isAutoDeployEnabled = null;
        Long modelTTLMinutes = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (fieldName == null) {
                parser.skipChildren();
                continue;
            }
            switch (fieldName) {
                case "is_auto_deploy_enabled": {
                    isAutoDeployEnabled = parser.booleanValue();
                    continue block8;
                }
                case "model_ttl_minutes": {
                    modelTTLMinutes = parser.longValue();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new MLDeploySetting(Boolean.TRUE.equals(isAutoDeployEnabled), modelTTLMinutes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.isAutoDeployEnabled != null) {
            builder.field(IS_AUTO_DEPLOY_ENABLED_FIELD, this.isAutoDeployEnabled);
        }
        if (this.modelTTLInMinutes != null) {
            builder.field(MODEL_TTL_MINUTES_FIELD, this.modelTTLInMinutes);
        }
        builder.endObject();
        return builder;
    }

    public static class Builder {
        private Boolean isAutoDeployEnabled;
        private Long modelTTLInMinutes;

        public Builder isAutoDeployEnabled(Boolean autoDeployEnabled) {
            this.isAutoDeployEnabled = autoDeployEnabled;
            return this;
        }

        public Builder modelTTLInMinutes(Long modelTTLInMinutes) {
            this.modelTTLInMinutes = modelTTLInMinutes;
            return this;
        }

        public MLDeploySetting build() {
            return new MLDeploySetting(this.isAutoDeployEnabled, this.modelTTLInMinutes);
        }
    }
}

