/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.execute.anomalylocalization;

import io.skylite.common.util.Counter;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.ExecuteOutput;
import io.skylite.ml.common.output.Output;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

@ExecuteOutput(algorithms={FunctionName.ANOMALY_LOCALIZATION})
public class AnomalyLocalizationOutput
implements Output {
    public static final String FIELD_RESULTS = "results";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_RESULT = "result";
    private Map<String, Result> results = new HashMap<String, Result>();

    public AnomalyLocalizationOutput() {
    }

    public AnomalyLocalizationOutput(StreamInput in) throws IOException {
        this.results = in.readMap(StreamInput::readString, Result::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.results, StreamOutput::writeString, (o, r) -> r.writeTo(o));
    }

    public Map<String, Result> getResults() {
        return this.results;
    }

    public void setResults(Map<String, Result> results) {
        this.results = results;
    }

    public String toString() {
        return "AnomalyLocalizationOutput{results=" + String.valueOf(this.results) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyLocalizationOutput that = (AnomalyLocalizationOutput)o;
        return Objects.equals(this.results, that.results);
    }

    public int hashCode() {
        return Objects.hashCode(this.results);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(FIELD_RESULTS);
        for (Map.Entry<String, Result> entry : this.results.entrySet()) {
            builder.startObject();
            builder.field(FIELD_NAME, entry.getKey());
            builder.field(FIELD_RESULT, (ToXContent)entry.getValue());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static AnomalyLocalizationOutput parse(XContentParser parser) throws IOException {
        AnomalyLocalizationOutput output = new AnomalyLocalizationOutput();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "results": {
                    AnomalyLocalizationOutput.parseResultMapEntry(parser, output);
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return output;
    }

    private static void parseResultMapEntry(XContentParser parser, AnomalyLocalizationOutput output) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            String key = null;
            Result result = new Result();
            block9: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                switch (parser.currentName()) {
                    case "name": {
                        parser.nextToken();
                        key = parser.text();
                        continue block9;
                    }
                    case "result": {
                        AnomalyLocalizationOutput.parseResult(parser, result);
                        continue block9;
                    }
                }
                parser.skipChildren();
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            output.getResults().put(key, result);
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    private static void parseResult(XContentParser parser, Result result) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "buckets": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        Bucket bucket = new Bucket();
                        AnomalyLocalizationOutput.parseBucket(parser, bucket);
                        result.getBuckets().add(bucket);
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                }
            }
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    private static void parseBucket(XContentParser parser, Bucket bucket) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "start_time": {
                    parser.nextToken();
                    bucket.setStartTime(parser.longValue());
                    continue block12;
                }
                case "end_time": {
                    parser.nextToken();
                    bucket.setEndTime(parser.longValue());
                    continue block12;
                }
                case "overall_aggregate_value": {
                    parser.nextToken();
                    bucket.setOverallAggValue(parser.doubleValue());
                    continue block12;
                }
                case "entities": {
                    AnomalyLocalizationOutput.parseEntities(parser, bucket);
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    private static void parseEntities(XContentParser parser, Bucket bucket) throws IOException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            Entity entity = new Entity();
            block13: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                switch (parser.currentName()) {
                    case "key": {
                        ArrayList<String> key = new ArrayList<String>();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            key.add(parser.text());
                        }
                        entity.setKey(key);
                        continue block13;
                    }
                    case "contribution_value": {
                        parser.nextToken();
                        entity.setContributionValue(parser.doubleValue());
                        continue block13;
                    }
                    case "base_value": {
                        parser.nextToken();
                        entity.setBaseValue(parser.doubleValue());
                        continue block13;
                    }
                    case "new_value": {
                        parser.nextToken();
                        entity.setNewValue(parser.doubleValue());
                        continue block13;
                    }
                }
                parser.skipChildren();
            }
            entities.add(entity);
        }
        bucket.setEntities(entities);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    public static class Result
    implements Output {
        public static final String FIELD_BUCKETS = "buckets";
        private List<Bucket> buckets = new ArrayList<Bucket>();

        public Result() {
        }

        public Result(StreamInput in) throws IOException {
            this.buckets = in.readList(Bucket::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.buckets);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FIELD_BUCKETS, (Object)this.buckets.toArray());
            builder.endObject();
            return builder;
        }

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public void setBuckets(List<Bucket> buckets) {
            this.buckets = buckets;
        }

        public String toString() {
            return "Result{buckets=" + String.valueOf(this.buckets) + "}";
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.buckets, result.buckets);
        }

        public int hashCode() {
            return Objects.hashCode(this.buckets);
        }
    }

    public static class Bucket
    implements Output {
        public static final String FIELD_START_TIME = "start_time";
        public static final String FIELD_END_TIME = "end_time";
        public static final String FIELD_OVERALL_VALUE = "overall_aggregate_value";
        public static final String FIELD_ENTITIES = "entities";
        private long startTime;
        private long endTime;
        private double overallAggValue;
        private List<Entity> entities = null;
        private Optional<Bucket> base = Optional.empty();
        private Optional<Counter> counter = Optional.empty();
        private AtomicBoolean completed = null;

        public Bucket() {
        }

        public Bucket(StreamInput in) throws IOException {
            this.startTime = in.readLong();
            this.endTime = in.readLong();
            this.overallAggValue = in.readDouble();
            if (in.readBoolean()) {
                this.entities = in.readList(Entity::new);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.startTime);
            out.writeLong(this.endTime);
            out.writeDouble(this.overallAggValue);
            if (this.entities == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeList(this.entities);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FIELD_START_TIME, this.startTime);
            builder.field(FIELD_END_TIME, this.endTime);
            builder.field(FIELD_OVERALL_VALUE, this.overallAggValue);
            if (this.entities != null && !this.entities.isEmpty()) {
                builder.field(FIELD_ENTITIES, this.entities);
            }
            builder.endObject();
            return builder;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public double getOverallAggValue() {
            return this.overallAggValue;
        }

        public void setOverallAggValue(double overallAggValue) {
            this.overallAggValue = overallAggValue;
        }

        public List<Entity> getEntities() {
            return this.entities;
        }

        public void setEntities(List<Entity> entities) {
            this.entities = entities;
        }

        public Optional<Bucket> getBase() {
            return this.base;
        }

        public void setBase(Optional<Bucket> base) {
            this.base = base;
        }

        public Optional<Counter> getCounter() {
            return this.counter;
        }

        public void setCounter(Optional<Counter> counter) {
            this.counter = counter;
        }

        public AtomicBoolean getCompleted() {
            return this.completed;
        }

        public void setCompleted(AtomicBoolean completed) {
            this.completed = completed;
        }

        public String toString() {
            return "Bucket{startTime=" + this.startTime + ", endTime=" + this.endTime + ", overallAggValue=" + this.overallAggValue + ", entities=" + String.valueOf(this.entities) + "}";
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            return this.startTime == bucket.startTime && this.endTime == bucket.endTime && Double.compare(this.overallAggValue, bucket.overallAggValue) == 0 && Objects.equals(this.entities, bucket.entities);
        }

        public int hashCode() {
            return Objects.hash(this.startTime, this.endTime, this.overallAggValue, this.entities);
        }
    }

    public static class Entity
    implements Output {
        public static final String FIELD_KEY = "key";
        public static final String FIELD_CONTRIBUTION_VALUE = "contribution_value";
        public static final String FIELD_BASE_VALUE = "base_value";
        public static final String FIELD_NEW_VALUE = "new_value";
        private List<String> key;
        private double contributionValue;
        private double baseValue;
        private double newValue;

        public Entity() {
        }

        public Entity(StreamInput in) throws IOException {
            this.key = in.readList(StreamInput::readString);
            this.contributionValue = in.readDouble();
            this.baseValue = in.readDouble();
            this.newValue = in.readDouble();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.key);
            out.writeDouble(this.contributionValue);
            out.writeDouble(this.baseValue);
            out.writeDouble(this.newValue);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FIELD_KEY, this.key);
            builder.field(FIELD_CONTRIBUTION_VALUE, this.contributionValue);
            builder.field(FIELD_BASE_VALUE, this.baseValue);
            builder.field(FIELD_NEW_VALUE, this.newValue);
            builder.endObject();
            return builder;
        }

        public List<String> getKey() {
            return this.key;
        }

        public void setKey(List<String> key) {
            this.key = key;
        }

        public double getContributionValue() {
            return this.contributionValue;
        }

        public void setContributionValue(double contributionValue) {
            this.contributionValue = contributionValue;
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public void setBaseValue(double baseValue) {
            this.baseValue = baseValue;
        }

        public double getNewValue() {
            return this.newValue;
        }

        public void setNewValue(double newValue) {
            this.newValue = newValue;
        }

        public String toString() {
            return "Entity{key=" + String.valueOf(this.key) + ", contributionValue=" + this.contributionValue + ", baseValue=" + this.baseValue + ", newValue=" + this.newValue + "}";
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity entity = (Entity)o;
            return Double.compare(this.contributionValue, entity.contributionValue) == 0 && Double.compare(this.baseValue, entity.baseValue) == 0 && Double.compare(this.newValue, entity.newValue) == 0 && Objects.equals(this.key, entity.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.contributionValue, this.baseValue, this.newValue);
        }
    }
}

