/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.execute.metrics_correlation;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class MCorrModelTensor
implements Writeable,
ToXContentObject {
    public static final String EVENT_WINDOW = "event_window";
    public static final String EVENT_PATTERN = "event_pattern";
    public static final String SUSPECTED_METRICS = "suspected_metrics";
    private float[] eventWindow;
    private float[] eventPattern;
    private long[] suspectedMetrics;

    public MCorrModelTensor(float[] eventWindow, float[] eventPattern, long[] suspectedMetrics) {
        this.eventWindow = eventWindow;
        this.eventPattern = eventPattern;
        this.suspectedMetrics = suspectedMetrics;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.eventWindow != null) {
            builder.field(EVENT_WINDOW, (Object)this.eventWindow);
        }
        if (this.eventPattern != null) {
            builder.field(EVENT_PATTERN, (Object)this.eventPattern);
        }
        if (this.suspectedMetrics != null) {
            builder.field(SUSPECTED_METRICS, (Object)this.suspectedMetrics);
        }
        builder.endObject();
        return builder;
    }

    public MCorrModelTensor(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.eventWindow = in.readFloatArray();
        }
        if (in.readBoolean()) {
            this.eventPattern = in.readFloatArray();
        }
        if (in.readBoolean()) {
            this.suspectedMetrics = in.readLongArray();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.eventWindow != null) {
            out.writeBoolean(true);
            out.writeFloatArray(this.eventWindow);
        } else {
            out.writeBoolean(false);
        }
        if (this.eventPattern != null) {
            out.writeBoolean(true);
            out.writeFloatArray(this.eventPattern);
        } else {
            out.writeBoolean(false);
        }
        if (this.suspectedMetrics != null) {
            out.writeBoolean(true);
            out.writeLongArray(this.suspectedMetrics);
        } else {
            out.writeBoolean(false);
        }
    }

    public float[] getEventWindow() {
        return this.eventWindow;
    }

    public void setEventWindow(float[] event_window) {
        this.eventWindow = event_window;
    }

    public float[] getEventPattern() {
        return this.eventPattern;
    }

    public void setEventPattern(float[] event_pattern) {
        this.eventPattern = event_pattern;
    }

    public long[] getSuspectedMetrics() {
        return this.suspectedMetrics;
    }

    public void setSuspectedMetrics(long[] suspected_metrics) {
        this.suspectedMetrics = suspected_metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MCorrModelTensor{eventWindow=" + Arrays.toString(this.eventWindow) + ", eventPattern=" + Arrays.toString(this.eventPattern) + ", suspectedMetrics=" + Arrays.toString(this.suspectedMetrics) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCorrModelTensor that = (MCorrModelTensor)o;
        return Objects.deepEquals(this.eventWindow, that.eventWindow) && Objects.deepEquals(this.eventPattern, that.eventPattern) && Objects.deepEquals(this.suspectedMetrics, that.suspectedMetrics);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.eventWindow), Arrays.hashCode(this.eventPattern), Arrays.hashCode(this.suspectedMetrics));
    }

    public static class Builder {
        private float[] eventWindow;
        private float[] eventPattern;
        private long[] suspectedMetrics;

        public MCorrModelTensor build() {
            return new MCorrModelTensor(this.eventWindow, this.eventPattern, this.suspectedMetrics);
        }

        public Builder eventWindow(float[] eventWindow) {
            this.eventWindow = eventWindow;
            return this;
        }

        public Builder eventPattern(float[] eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public Builder suspectedMetrics(long[] suspectedMetrics) {
            this.suspectedMetrics = suspectedMetrics;
            return this;
        }
    }
}

