/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.execute.metrics_correlation;

import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.output.execute.metrics_correlation.MCorrModelTensor;
import io.skylite.ml.common.output.model.ModelResultFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCorrModelTensors
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(MCorrModelTensors.class);
    public static final String OUTPUT_FIELD = "output";
    private List<MCorrModelTensor> mCorrModelTensors;

    public MCorrModelTensors(List<MCorrModelTensor> mCorrModelTensors) {
        this.mCorrModelTensors = mCorrModelTensors;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.mCorrModelTensors != null && this.mCorrModelTensors.size() > 0) {
            for (MCorrModelTensor output : this.mCorrModelTensors) {
                output.toXContent(builder, params);
            }
        }
        return builder;
    }

    public MCorrModelTensors(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.mCorrModelTensors = new ArrayList<MCorrModelTensor>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.mCorrModelTensors.add(new MCorrModelTensor(in));
            }
        }
    }

    public List<MCorrModelTensor> getMCorrModelTensors() {
        return this.mCorrModelTensors;
    }

    public void setMCorrModelTensors(List<MCorrModelTensor> mCorrModelTensors) {
        this.mCorrModelTensors = mCorrModelTensors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.mCorrModelTensors != null && this.mCorrModelTensors.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.mCorrModelTensors.size());
            for (MCorrModelTensor output : this.mCorrModelTensors) {
                output.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void filter(ModelResultFilter resultFilter) {
        boolean returnNumber = resultFilter.isReturnNumber();
        List<String> targetResponse = resultFilter.getTargetResponse();
        List<Integer> targetResponsePositions = resultFilter.getTargetResponsePositions();
        if (!(targetResponse != null && targetResponse.size() != 0 || targetResponsePositions != null && targetResponsePositions.size() != 0)) {
            this.mCorrModelTensors.forEach(output -> this.filter((MCorrModelTensor)output, returnNumber));
            return;
        }
        ArrayList<MCorrModelTensor> targetOutput = new ArrayList<MCorrModelTensor>();
        if (this.mCorrModelTensors != null) {
            for (int i = 0; i < this.mCorrModelTensors.size(); ++i) {
                MCorrModelTensor output2 = this.mCorrModelTensors.get(i);
                if (targetResponse != null && targetResponse.contains(output2.getEventWindow())) {
                    this.filter(output2, returnNumber);
                    targetOutput.add(output2);
                    continue;
                }
                if (targetResponsePositions == null || !targetResponsePositions.contains(i)) continue;
                this.filter(output2, returnNumber);
                targetOutput.add(output2);
            }
        }
        this.mCorrModelTensors = targetOutput;
    }

    private void filter(MCorrModelTensor output, boolean returnNUmber) {
        if (!returnNUmber) {
            output.setEventPattern(null);
            output.setSuspectedMetrics(null);
            output.setEventWindow(null);
        }
    }

    public byte[] toBytes() {
        byte[] byArray;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            bytesStreamOutput.flush();
            byArray = bytesStreamOutput.bytes().toBytesRef().bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MLException("Failed to parse result", e);
            }
        }
        bytesStreamOutput.close();
        return byArray;
    }

    public static MCorrModelTensors fromBytes(byte[] bytes) {
        MCorrModelTensors mCorrModelTensors;
        block8: {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            StreamInput streamInput = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer).streamInput();
            try {
                mCorrModelTensors = new MCorrModelTensors(streamInput);
                if (streamInput == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (streamInput != null) {
                        try {
                            streamInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String errorMsg = "Failed to parse output";
                    throw new MLException(errorMsg, e);
                }
            }
            streamInput.close();
        }
        return mCorrModelTensors;
    }

    public String toString() {
        return "MCorrModelTensors{mCorrModelTensors=" + String.valueOf(this.mCorrModelTensors) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCorrModelTensors that = (MCorrModelTensors)o;
        return Objects.equals(this.mCorrModelTensors, that.mCorrModelTensors);
    }

    public int hashCode() {
        return Objects.hashCode(this.mCorrModelTensors);
    }

    public static class Builder {
        private List<MCorrModelTensor> mCorrModelTensors;

        public MCorrModelTensors build() {
            return new MCorrModelTensors(this.mCorrModelTensors);
        }

        public Builder mCorrModelTensors(List<MCorrModelTensor> mCorrModelTensors) {
            this.mCorrModelTensors = mCorrModelTensors;
            return this;
        }
    }
}

