/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.execute.metrics_correlation;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.ExecuteOutput;
import io.skylite.ml.common.output.MLOutputType;
import io.skylite.ml.common.output.Output;
import io.skylite.ml.common.output.execute.metrics_correlation.MCorrModelTensors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ExecuteOutput(algorithms={FunctionName.METRICS_CORRELATION})
public class MetricsCorrelationOutput
implements Output {
    private static final Logger log = LogManager.getLogger(MetricsCorrelationOutput.class);
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.MCORR_TENSOR;
    private List<MCorrModelTensors> modelOutput;
    public static final String INFERENCE_RESULT_FIELD = "inference_results";

    public MetricsCorrelationOutput(List<MCorrModelTensors> modelOutput) {
        this.modelOutput = modelOutput;
    }

    public MetricsCorrelationOutput(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.modelOutput = new ArrayList<MCorrModelTensors>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.modelOutput.add(new MCorrModelTensors(in));
            }
        }
    }

    public List<MCorrModelTensors> getModelOutput() {
        return this.modelOutput;
    }

    public void setModelOutput(List<MCorrModelTensors> modelOutput) {
        this.modelOutput = modelOutput;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.modelOutput != null && this.modelOutput.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.modelOutput.size());
            for (MCorrModelTensors output : this.modelOutput) {
                output.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelOutput != null && this.modelOutput.size() > 0) {
            builder.startArray(INFERENCE_RESULT_FIELD);
            for (MCorrModelTensors output : this.modelOutput) {
                output.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "MetricsCorrelationOutput{modelOutput=" + String.valueOf(this.modelOutput) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsCorrelationOutput that = (MetricsCorrelationOutput)o;
        return Objects.equals(this.modelOutput, that.modelOutput);
    }

    public int hashCode() {
        return Objects.hashCode(this.modelOutput);
    }

    public static class Builder {
        private List<MCorrModelTensors> modelOutput;

        public MetricsCorrelationOutput build() {
            return new MetricsCorrelationOutput(this.modelOutput);
        }

        public Builder modelOutput(List<MCorrModelTensors> modelOutput) {
            this.modelOutput = modelOutput;
            return this;
        }
    }
}

