/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.execute.samplecalculator;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.ExecuteOutput;
import io.skylite.ml.common.output.Output;
import java.io.IOException;
import java.util.Objects;

@ExecuteOutput(algorithms={FunctionName.LOCAL_SAMPLE_CALCULATOR})
public class LocalSampleCalculatorOutput
implements Output {
    private Double result;

    public LocalSampleCalculatorOutput(Double totalSum) {
        this.result = totalSum;
    }

    public LocalSampleCalculatorOutput(StreamInput in) throws IOException {
        this.result = in.readOptionalDouble();
    }

    public Double getResult() {
        return this.result;
    }

    public void setResult(Double result) {
        this.result = result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.result);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.result != null) {
            builder.field("result", this.result);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "LocalSampleCalculatorOutput{result=" + this.result + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalSampleCalculatorOutput that = (LocalSampleCalculatorOutput)o;
        return Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hashCode(this.result);
    }

    public static class Builder {
        private Double result;

        public LocalSampleCalculatorOutput build() {
            return new LocalSampleCalculatorOutput(this.result);
        }

        public Builder totalSum(Double result) {
            this.result = result;
            return this;
        }
    }
}

