/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.output.model.MLResultDataType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelTensor
implements Writeable,
ToXContentObject {
    public static final String NAME_FIELD = "name";
    public static final String DATA_TYPE_FIELD = "data_type";
    public static final String SHAPE_FIELD = "shape";
    public static final String DATA_FIELD = "data";
    public static final String BYTE_BUFFER_FIELD = "byte_buffer";
    public static final String BYTE_BUFFER_ARRAY_FIELD = "array";
    public static final String BYTE_BUFFER_ORDER_FIELD = "order";
    public static final String RESULT_FIELD = "result";
    public static final String DATA_AS_MAP_FIELD = "dataAsMap";
    private String name;
    private Number[] data;
    private long[] shape;
    private MLResultDataType dataType;
    private ByteBuffer byteBuffer;
    private String result;
    private Map<String, ?> dataAsMap;

    public ModelTensor(String name, Number[] data, long[] shape, MLResultDataType dataType, ByteBuffer byteBuffer, String result, Map<String, ?> dataAsMap) {
        if (data != null && (dataType == null || dataType == MLResultDataType.UNKNOWN)) {
            throw new IllegalArgumentException("data type is null");
        }
        this.name = name;
        this.data = data;
        this.shape = shape;
        this.dataType = dataType;
        this.byteBuffer = byteBuffer;
        this.result = result;
        this.dataAsMap = dataAsMap;
    }

    public ModelTensor(String name, String result) {
        this.name = name;
        this.result = result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.dataType != null) {
            builder.field(DATA_TYPE_FIELD, (Object)this.dataType);
        }
        if (this.shape != null) {
            builder.field(SHAPE_FIELD, (Object)this.shape);
        }
        if (this.data != null) {
            builder.field(DATA_FIELD, (Object)this.data);
        }
        if (this.byteBuffer != null) {
            builder.startObject(BYTE_BUFFER_FIELD);
            builder.field(BYTE_BUFFER_ARRAY_FIELD, this.byteBuffer.array());
            builder.field(BYTE_BUFFER_ORDER_FIELD, this.byteBuffer.order().toString());
            builder.endObject();
        }
        if (this.result != null) {
            builder.field(RESULT_FIELD, this.result);
        }
        if (this.dataAsMap != null) {
            builder.field(DATA_AS_MAP_FIELD, this.dataAsMap);
        }
        builder.endObject();
        return builder;
    }

    public static ModelTensor parser(XContentParser parser) throws IOException {
        String name = null;
        List dataList = null;
        Number[] data = null;
        long[] shape = null;
        MLResultDataType dataType = null;
        ByteBuffer byteBuffer = null;
        String result = null;
        Map dataAsMap = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block26: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "data": {
                    dataList = parser.list();
                    break;
                }
                case "data_type": {
                    dataType = MLResultDataType.valueOf(parser.text());
                    break;
                }
                case "shape": {
                    ArrayList<Long> shapeList = new ArrayList<Long>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        shapeList.add(parser.longValue());
                    }
                    shape = new long[shapeList.size()];
                    for (int i = 0; i < shapeList.size(); ++i) {
                        shape[i] = (Long)shapeList.get(i);
                    }
                    continue block26;
                }
                case "result": {
                    result = parser.text();
                    break;
                }
                case "dataAsMap": {
                    dataAsMap = parser.map();
                    break;
                }
                case "byte_buffer": {
                    byte[] bytes = null;
                    ByteOrder order = null;
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String byteBufferFieldName = parser.currentName();
                        parser.nextToken();
                        switch (byteBufferFieldName) {
                            case "array": {
                                bytes = parser.binaryValue();
                                break;
                            }
                            case "order": {
                                String orderName = parser.text();
                                if (ByteOrder.LITTLE_ENDIAN.toString().equals(orderName)) {
                                    order = ByteOrder.LITTLE_ENDIAN;
                                    break;
                                }
                                if (!ByteOrder.BIG_ENDIAN.toString().equals(orderName)) break;
                                order = ByteOrder.BIG_ENDIAN;
                            }
                        }
                        if (bytes == null) continue;
                        byteBuffer = ByteBuffer.wrap(bytes);
                        if (order == null) continue;
                        byteBuffer.order(order);
                    }
                    continue block26;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        if (dataType != null && dataList != null && dataList.size() > 0) {
            data = new Number[dataList.size()];
            for (int i = 0; i < dataList.size(); ++i) {
                data[i] = (Number)dataList.get(i);
            }
        }
        return ModelTensor.builder().name(name).shape(shape).dataType(dataType).data(data).result(result).dataAsMap(dataAsMap).build();
    }

    public ModelTensor(StreamInput in) throws IOException {
        this.name = in.readOptionalString();
        if (in.readBoolean()) {
            this.dataType = (MLResultDataType)in.readEnum(MLResultDataType.class);
        }
        if (in.readBoolean()) {
            this.shape = in.readLongArray();
        }
        if (in.readBoolean()) {
            int size = in.readInt();
            this.data = new Number[size];
            if (this.dataType.isFloating()) {
                for (i = 0; i < size; ++i) {
                    this.data[i] = Float.valueOf(in.readFloat());
                }
            } else if (this.dataType.isInteger() || this.dataType.isBoolean()) {
                for (i = 0; i < size; ++i) {
                    this.data[i] = in.readInt();
                }
            } else {
                this.data = null;
            }
        }
        if (in.readBoolean()) {
            String orderName = in.readString();
            ByteOrder byteOrder = null;
            if (ByteOrder.BIG_ENDIAN.toString().equals(orderName)) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(orderName)) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                throw new IllegalArgumentException("wrong byte order");
            }
            byte[] bytes = in.readByteArray();
            this.byteBuffer = ByteBuffer.wrap(bytes);
            this.byteBuffer.order(byteOrder);
        }
        this.result = in.readOptionalString();
        if (in.readBoolean()) {
            String mapStr = in.readString();
            this.dataAsMap = (Map)Strings.fromJson((String)mapStr, Map.class);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        if (this.dataType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.dataType);
        } else {
            out.writeBoolean(false);
        }
        if (this.shape != null) {
            out.writeBoolean(true);
            out.writeLongArray(this.shape);
        } else {
            out.writeBoolean(false);
        }
        if (this.data != null && this.dataType != null && this.dataType != MLResultDataType.UNKNOWN) {
            out.writeBoolean(true);
            out.writeInt(this.data.length);
            if (this.dataType.isFloating()) {
                for (Number n : this.data) {
                    out.writeFloat(n.floatValue());
                }
            } else if (this.dataType.isInteger() || this.dataType.isBoolean()) {
                for (Number n : this.data) {
                    out.writeInt(n.intValue());
                }
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.byteBuffer != null && this.byteBuffer.hasArray()) {
            out.writeBoolean(true);
            out.writeString(this.byteBuffer.order().toString());
            out.writeByteArray(this.byteBuffer.array());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.result);
        if (this.dataAsMap != null) {
            out.writeBoolean(true);
            try {
                AccessController.doPrivileged(() -> {
                    out.writeString(Strings.toJson(this.dataAsMap));
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelTensor that = (ModelTensor)o;
        return Objects.equals(this.name, that.name) && Objects.deepEquals(this.data, that.data) && Objects.deepEquals(this.shape, that.shape) && this.dataType == that.dataType && Objects.equals(this.byteBuffer, that.byteBuffer) && Objects.equals(this.result, that.result) && Objects.equals(this.dataAsMap, that.dataAsMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, Arrays.hashCode(this.data), Arrays.hashCode(this.shape), this.dataType, this.byteBuffer, this.result, this.dataAsMap});
    }

    public String getName() {
        return this.name;
    }

    public ModelTensor setName(String name) {
        this.name = name;
        return this;
    }

    public Number[] getData() {
        return this.data;
    }

    public ModelTensor setData(Number[] data) {
        this.data = data;
        return this;
    }

    public long[] getShape() {
        return this.shape;
    }

    public ModelTensor setShape(long[] shape) {
        this.shape = shape;
        return this;
    }

    public MLResultDataType getDataType() {
        return this.dataType;
    }

    public ModelTensor setDtaType(MLResultDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ModelTensor setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        return this;
    }

    public String getResult() {
        return this.result;
    }

    public ModelTensor setResult(String result) {
        this.result = result;
        return this;
    }

    public Map<String, ?> getDataAsMap() {
        return this.dataAsMap;
    }

    public ModelTensor setDataAsMap(Map<String, ?> dataAsMap) {
        this.dataAsMap = dataAsMap;
        return this;
    }

    public static class Builder {
        private String name;
        private Number[] data;
        private long[] shape;
        private MLResultDataType dataType;
        private ByteBuffer byteBuffer;
        private String result;
        private Map<String, ?> dataAsMap;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder data(Number[] data) {
            this.data = data;
            return this;
        }

        public Builder shape(long[] shape) {
            this.shape = shape;
            return this;
        }

        public Builder dataType(MLResultDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder byteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        public Builder result(String result) {
            this.result = result;
            return this;
        }

        public Builder dataAsMap(Map<String, ?> dataAsMap) {
            this.dataAsMap = dataAsMap;
            return this;
        }

        public ModelTensor build() {
            return new ModelTensor(this.name, this.data, this.shape, this.dataType, this.byteBuffer, this.result, this.dataAsMap);
        }
    }
}

