/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.model;

import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.output.model.ModelResultFilter;
import io.skylite.ml.common.output.model.ModelTensor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ModelTensors
implements Writeable,
ToXContentObject {
    public static final String OUTPUT_FIELD = "output";
    public static final String STATUS_CODE_FIELD = "status_code";
    private List<ModelTensor> mlModelTensors;
    private Integer statusCode;

    public ModelTensors(List<ModelTensor> mlModelTensors) {
        this.mlModelTensors = mlModelTensors;
    }

    public ModelTensors(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public ModelTensors(List<ModelTensor> mlModelTensors, Integer statusCode) {
        this.mlModelTensors = mlModelTensors;
        this.statusCode = statusCode;
    }

    public ModelTensors(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.mlModelTensors = new ArrayList<ModelTensor>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.mlModelTensors.add(new ModelTensor(in));
            }
        }
        this.statusCode = in.readOptionalInt();
    }

    public List<ModelTensor> getMlModelTensors() {
        return this.mlModelTensors;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public ModelTensors setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.mlModelTensors != null && this.mlModelTensors.size() > 0) {
            builder.startArray(OUTPUT_FIELD);
            for (ModelTensor output : this.mlModelTensors) {
                output.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.statusCode != null) {
            builder.field(STATUS_CODE_FIELD, this.statusCode);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.mlModelTensors != null && this.mlModelTensors.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.mlModelTensors.size());
            for (ModelTensor output : this.mlModelTensors) {
                output.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInt(this.statusCode);
    }

    public void filter(ModelResultFilter resultFilter) {
        boolean returnBytes = resultFilter.isReturnBytes();
        boolean returnNumber = resultFilter.isReturnNumber();
        List<String> targetResponse = resultFilter.getTargetResponse();
        List<Integer> targetResponsePositions = resultFilter.getTargetResponsePositions();
        if (!(targetResponse != null && targetResponse.size() != 0 || targetResponsePositions != null && targetResponsePositions.size() != 0)) {
            this.mlModelTensors.forEach(output -> this.filter((ModelTensor)output, returnBytes, returnNumber));
            return;
        }
        ArrayList<ModelTensor> targetOutput = new ArrayList<ModelTensor>();
        if (this.mlModelTensors != null) {
            for (int i = 0; i < this.mlModelTensors.size(); ++i) {
                ModelTensor output2 = this.mlModelTensors.get(i);
                if (targetResponse != null && targetResponse.contains(output2.getName())) {
                    this.filter(output2, returnBytes, returnNumber);
                    targetOutput.add(output2);
                    continue;
                }
                if (targetResponsePositions == null || !targetResponsePositions.contains(i)) continue;
                this.filter(output2, returnBytes, returnNumber);
                targetOutput.add(output2);
            }
        }
        this.mlModelTensors = targetOutput;
    }

    private void filter(ModelTensor output, boolean returnBytes, boolean returnNUmber) {
        if (!returnBytes) {
            output.setByteBuffer(null);
        }
        if (!returnNUmber) {
            output.setData(null);
        }
    }

    public byte[] toBytes() {
        byte[] byArray;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            byte[] bytes;
            this.writeTo((StreamOutput)bytesStreamOutput);
            bytesStreamOutput.flush();
            byArray = bytes = bytesStreamOutput.bytes().toBytesRef().bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MLException("Failed to parse result", e);
            }
        }
        bytesStreamOutput.close();
        return byArray;
    }

    public static ModelTensors fromBytes(byte[] bytes) {
        ModelTensors modelTensors;
        block8: {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            StreamInput streamInput = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer).streamInput();
            try {
                ModelTensors tensorOutput;
                modelTensors = tensorOutput = new ModelTensors(streamInput);
                if (streamInput == null) break block8;
            }
            catch (Throwable tensorOutput) {
                try {
                    if (streamInput != null) {
                        try {
                            streamInput.close();
                        }
                        catch (Throwable throwable) {
                            tensorOutput.addSuppressed(throwable);
                        }
                    }
                    throw tensorOutput;
                }
                catch (Exception e) {
                    String errorMsg = "Failed to parse output";
                    throw new MLException(errorMsg, e);
                }
            }
            streamInput.close();
        }
        return modelTensors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected List<ModelTensor> mlModelTensors;
        protected Integer statusCode;

        public Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder mlModelTensors(List<ModelTensor> mlModelTensors) {
            this.mlModelTensors = mlModelTensors;
            return this;
        }

        public ModelTensors build() {
            if (this.mlModelTensors != null && this.statusCode != null) {
                return new ModelTensors(this.mlModelTensors, this.statusCode);
            }
            if (this.mlModelTensors != null) {
                return new ModelTensors(this.mlModelTensors);
            }
            return new ModelTensors(this.statusCode);
        }
    }
}

