/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.profile;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.stats.MLPredictRequestStats;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLModelProfile
implements ToXContentFragment,
Writeable {
    private static final Logger log = LogManager.getLogger(MLModelProfile.class);
    private final MLModelState modelState;
    private final String predictor;
    private final String[] targetWorkerNodes;
    private final String[] workerNodes;
    private final MLPredictRequestStats modelInferenceStats;
    private final MLPredictRequestStats predictRequestStats;
    private final Long memSizeEstimationCPU;
    private final Long memSizeEstimationGPU;
    private Boolean isHidden;

    public MLModelProfile(MLModelState modelState, String predictor, String[] targetWorkerNodes, String[] workerNodes, MLPredictRequestStats modelInferenceStats, MLPredictRequestStats predictRequestStats, Long memSizeEstimationCPU, Long memSizeEstimationGPU) {
        this.modelState = modelState;
        this.predictor = predictor;
        this.targetWorkerNodes = targetWorkerNodes;
        this.workerNodes = workerNodes;
        this.modelInferenceStats = modelInferenceStats;
        this.predictRequestStats = predictRequestStats;
        this.memSizeEstimationCPU = memSizeEstimationCPU;
        this.memSizeEstimationGPU = memSizeEstimationGPU;
    }

    public MLModelState getModelState() {
        return this.modelState;
    }

    public String getPredictor() {
        return this.predictor;
    }

    public String[] getTargetWorkerNodes() {
        return this.targetWorkerNodes;
    }

    public String[] getWorkerNodes() {
        return this.workerNodes;
    }

    public MLPredictRequestStats getModelInferenceStats() {
        return this.modelInferenceStats;
    }

    public MLPredictRequestStats getPredictRequestStats() {
        return this.predictRequestStats;
    }

    public Long getMemSizeEstimationCPU() {
        return this.memSizeEstimationCPU;
    }

    public Long getMemSizeEstimationGPU() {
        return this.memSizeEstimationGPU;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean hidden) {
        this.isHidden = hidden;
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelState != null) {
            builder.field("model_state", (Object)this.modelState);
        }
        if (this.predictor != null) {
            builder.field("predictor", this.predictor);
        }
        if (this.targetWorkerNodes != null) {
            builder.field("target_worker_nodes", (Object)this.targetWorkerNodes);
        }
        if (this.workerNodes != null) {
            builder.field("worker_nodes", (Object)this.workerNodes);
        }
        if (this.modelInferenceStats != null) {
            builder.field("model_inference_stats", (ToXContent)this.modelInferenceStats);
        }
        if (this.predictRequestStats != null) {
            builder.field("predict_request_stats", (ToXContent)this.predictRequestStats);
        }
        if (this.memSizeEstimationCPU != null) {
            builder.field("memory_size_estimation_cpu", this.memSizeEstimationCPU);
        }
        if (this.memSizeEstimationGPU != null) {
            builder.field("memory_size_estimation_gpu", this.memSizeEstimationGPU);
        }
        if (this.isHidden != null && this.isHidden.booleanValue()) {
            builder.field("is_hidden", true);
        }
        builder.endObject();
        return builder;
    }

    public MLModelProfile(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.modelState = in.readBoolean() ? (MLModelState)in.readEnum(MLModelState.class) : null;
        this.predictor = in.readOptionalString();
        this.targetWorkerNodes = in.readOptionalStringArray();
        this.workerNodes = in.readOptionalStringArray();
        this.modelInferenceStats = in.readBoolean() ? new MLPredictRequestStats(in) : null;
        this.predictRequestStats = in.readBoolean() ? new MLPredictRequestStats(in) : null;
        this.memSizeEstimationCPU = in.readOptionalLong();
        this.memSizeEstimationGPU = in.readOptionalLong();
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isHidden = in.readOptionalBoolean();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.predictor);
        out.writeOptionalStringArray(this.targetWorkerNodes);
        out.writeOptionalStringArray(this.workerNodes);
        if (this.modelInferenceStats != null) {
            out.writeBoolean(true);
            this.modelInferenceStats.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.predictRequestStats != null) {
            out.writeBoolean(true);
            this.predictRequestStats.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.memSizeEstimationCPU);
        out.writeOptionalLong(this.memSizeEstimationGPU);
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isHidden);
        }
    }

    public static class Builder {
        private MLModelState modelState;
        private String predictor;
        private String[] targetWorkerNodes;
        private String[] workerNodes;
        private MLPredictRequestStats modelInferenceStats;
        private MLPredictRequestStats predictRequestStats;
        private Long memSizeEstimationCPU;
        private Long memSizeEstimationGPU;
        private Boolean isHidden;

        public Builder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        public Builder predictor(String predictor) {
            this.predictor = predictor;
            return this;
        }

        public Builder targetWorkerNodes(String[] targetWorkerNodes) {
            this.targetWorkerNodes = targetWorkerNodes;
            return this;
        }

        public Builder workerNodes(String[] workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        public Builder modelInferenceStats(MLPredictRequestStats modelInferenceStats) {
            this.modelInferenceStats = modelInferenceStats;
            return this;
        }

        public Builder predictRequestStats(MLPredictRequestStats predictRequestStats) {
            this.predictRequestStats = predictRequestStats;
            return this;
        }

        public Builder memSizeEstimationCPU(Long memSizeEstimationCPU) {
            this.memSizeEstimationCPU = memSizeEstimationCPU;
            return this;
        }

        public Builder memSizeEstimationGPU(Long memSizeEstimationGPU) {
            this.memSizeEstimationGPU = memSizeEstimationGPU;
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public MLModelProfile build() {
            return new MLModelProfile(this.modelState, this.predictor, this.targetWorkerNodes, this.workerNodes, this.modelInferenceStats, this.predictRequestStats, this.memSizeEstimationCPU, this.memSizeEstimationGPU);
        }
    }
}

