/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.search.pipelines.generative.llm;

import io.skylite.ml.common.conversation.Interaction;
import io.skylite.ml.common.search.pipelines.generative.llm.ChatCompletionInput;
import io.skylite.ml.common.search.pipelines.generative.llm.Llm;
import io.skylite.ml.common.search.pipelines.generative.llm.MessageBlock;
import java.util.List;

public class LlmIOUtil {
    public static final String BEDROCK_PROVIDER_PREFIX = "bedrock/";
    public static final String COHERE_PROVIDER_PREFIX = "cohere/";
    public static final String BEDROCK_CONVERSE__PROVIDER_PREFIX = "bedrock-converse/";

    public static ChatCompletionInput createChatCompletionInput(String llmModel, String question, List<Interaction> chatHistory, List<String> contexts, int timeoutInSeconds, String llmResponseField) {
        return LlmIOUtil.createChatCompletionInput("Generate a concise and informative answer in less than 100 words for the given question, taking into context: - An enumerated list of search results- A rephrase of the question that was used to generate the search results- The conversation historyCite search results using [${number}] notation.Do not repeat yourself, and NEVER repeat anything in the chat history.If there are any necessary steps or procedures in your answer, enumerate them.", null, llmModel, question, chatHistory, contexts, timeoutInSeconds, llmResponseField, null);
    }

    public static ChatCompletionInput createChatCompletionInput(String systemPrompt, String userInstructions, String llmModel, String question, List<Interaction> chatHistory, List<String> contexts, int timeoutInSeconds, String llmResponseField, List<MessageBlock> llmMessages) {
        Llm.ModelProvider provider = null;
        if (llmResponseField == null) {
            provider = Llm.ModelProvider.OPENAI;
            if (llmModel != null) {
                if (llmModel.startsWith(BEDROCK_PROVIDER_PREFIX)) {
                    provider = Llm.ModelProvider.BEDROCK;
                } else if (llmModel.startsWith(COHERE_PROVIDER_PREFIX)) {
                    provider = Llm.ModelProvider.COHERE;
                } else if (llmModel.startsWith(BEDROCK_CONVERSE__PROVIDER_PREFIX)) {
                    provider = Llm.ModelProvider.BEDROCK_CONVERSE;
                }
            }
        }
        return new ChatCompletionInput(llmModel, question, chatHistory, contexts, timeoutInSeconds, systemPrompt, userInstructions, provider, llmResponseField, llmMessages);
    }
}

