/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.search.pipelines.generative.llm;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParseException;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MessageBlock
implements Writeable,
ToXContent {
    private static final String TEXT_BLOCK = "text";
    private static final String IMAGE_BLOCK = "image";
    private static final String DOCUMENT_BLOCK = "document";
    private String role;
    private List<AbstractBlock> blockList = new ArrayList<AbstractBlock>();

    public MessageBlock() {
    }

    public MessageBlock(Map<String, ?> map) {
        this.setMessageBlock(map);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.role);
        out.writeList(this.blockList);
    }

    public MessageBlock(StreamInput in) throws IOException {
        this.role = in.readString();
        Writeable.Reader reader = input -> {
            String type = input.readString();
            if (type.equals(TEXT_BLOCK)) {
                return new TextBlock(input);
            }
            if (type.equals(IMAGE_BLOCK)) {
                return new ImageBlock(input);
            }
            if (type.equals(DOCUMENT_BLOCK)) {
                return new DocumentBlock(input);
            }
            throw new RuntimeException("Unexpected type: " + type);
        };
        this.blockList = in.readList(reader);
    }

    public static MessageBlock fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return new MessageBlock(parser.map());
        }
        throw new XContentParseException(parser.getTokenLocation(), "Expected [START_OBJECT], got " + String.valueOf(parser.currentToken()));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("role", this.role);
        builder.startArray("content");
        for (AbstractBlock block : this.blockList) {
            block.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String getRole() {
        return this.role;
    }

    public List<AbstractBlock> getBlockList() {
        return this.blockList;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setBlockList(List<AbstractBlock> blockList) {
        this.blockList = blockList;
    }

    public void setMessageBlock(Map<String, ?> message) {
        Objects.requireNonNull(message, "message cannot be null.");
        if (!message.containsKey("role")) {
            throw new IllegalStateException("message must have a role.");
        }
        if (!message.containsKey("content")) {
            throw new IllegalStateException("message must have content.");
        }
        this.role = (String)message.get("role");
        List contents = (List)message.get("content");
        for (Map content : contents) {
            if (content.containsKey(TEXT_BLOCK)) {
                this.blockList.add(new TextBlock((String)content.get(TEXT_BLOCK)));
                continue;
            }
            if (content.containsKey(IMAGE_BLOCK)) {
                Map imageBlock = (Map)content.get(IMAGE_BLOCK);
                this.blockList.add(new ImageBlock(imageBlock));
                continue;
            }
            if (!content.containsKey(DOCUMENT_BLOCK)) continue;
            Map documentBlock = (Map)content.get(DOCUMENT_BLOCK);
            this.blockList.add(new DocumentBlock(documentBlock));
        }
    }

    public boolean equals(Object o) {
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.role) + Objects.hashCode(this.blockList);
    }

    public static abstract class AbstractBlock
    implements Block,
    Writeable,
    ToXContent {
        @Override
        public abstract String getType();

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    public static class TextBlock
    extends AbstractBlock {
        String type = "text";
        String text;

        public TextBlock(String text) {
            this.text = Objects.requireNonNull(text, "text cannot be null.");
        }

        public TextBlock(StreamInput in) throws IOException {
            this.text = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.text);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", MessageBlock.TEXT_BLOCK);
            builder.field(MessageBlock.TEXT_BLOCK, this.text);
            builder.endObject();
            return builder;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public static class ImageBlock
    extends AbstractBlock {
        String type = "image";
        String format;
        String data;
        String url;

        public ImageBlock(Map<String, ?> imageBlock) {
            this.format = (String)imageBlock.get("format");
            Object tmp = imageBlock.get("data");
            if (tmp != null) {
                this.data = (String)tmp;
            } else {
                tmp = imageBlock.get("url");
                if (tmp == null) {
                    throw new IllegalArgumentException("data or url not found in imageBlock.");
                }
                this.url = (String)tmp;
            }
        }

        public ImageBlock(String format, String data, String url) {
            if (data == null && url == null) {
                throw new IllegalArgumentException("data and url cannot both be null.");
            }
            this.format = Objects.requireNonNull(format, "format cannot be null.");
            this.data = data;
            this.url = url;
        }

        public ImageBlock(StreamInput in) throws IOException {
            this.format = in.readString();
            this.data = in.readOptionalString();
            this.url = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.format);
            out.writeOptionalString(this.data);
            out.writeOptionalString(this.url);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            HashMap<String, String> imageMap = new HashMap<String, String>();
            imageMap.put("format", this.format);
            if (this.data != null) {
                imageMap.put("data", this.data);
            } else if (this.url != null) {
                imageMap.put("url", this.url);
            }
            builder.field(MessageBlock.IMAGE_BLOCK, imageMap);
            builder.endObject();
            return builder;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public String getUrl() {
            return this.url;
        }

        public String getData() {
            return this.data;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class DocumentBlock
    extends AbstractBlock {
        String type = "document";
        String format;
        String name;
        String data;

        public DocumentBlock(Map<String, ?> documentBlock) {
            if (!documentBlock.containsKey("format")) {
                throw new IllegalStateException("format not found in the document block.");
            }
            if (!documentBlock.containsKey("name")) {
                throw new IllegalStateException("name not found in the document block.");
            }
            if (!documentBlock.containsKey("data")) {
                throw new IllegalStateException("data not found in the document block");
            }
            this.format = (String)documentBlock.get("format");
            this.name = (String)documentBlock.get("name");
            this.data = (String)documentBlock.get("data");
        }

        public DocumentBlock(String format, String name, String data) {
            this.format = Objects.requireNonNull(format, "format cannot be null.");
            this.name = Objects.requireNonNull(name, "name cannot be null.");
            this.data = Objects.requireNonNull(data, "data cannot be null.");
        }

        public DocumentBlock(StreamInput in) throws IOException {
            this.format = in.readString();
            this.name = in.readString();
            this.data = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.format);
            out.writeString(this.name);
            out.writeString(this.data);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(MessageBlock.DOCUMENT_BLOCK);
            builder.field("format", this.format);
            builder.field("name", this.name);
            builder.field("data", this.data);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public String getName() {
            return this.name;
        }

        public String getData() {
            return this.data;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    public static interface Block {
        public String getType();
    }
}

