/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.task;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MLTask
implements ToXContentObject,
Writeable {
    public static final String TASK_ID_FIELD = "task_id";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String TASK_TYPE_FIELD = "task_type";
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String STATE_FIELD = "state";
    public static final String INPUT_TYPE_FIELD = "input_type";
    public static final String PROGRESS_FIELD = "progress";
    public static final String OUTPUT_INDEX_FIELD = "output_index";
    public static final String WORKER_NODE_FIELD = "worker_node";
    public static final String CREATE_TIME_FIELD = "create_time";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String ERROR_FIELD = "error";
    public static final String IS_ASYNC_TASK_FIELD = "is_async";
    public static final String REMOTE_JOB_FIELD = "remote_job";
    public static final Version MINIMAL_SUPPORTED_VERSION_FOR_BATCH_PREDICTION_JOB = CommonValue.VERSION_2_17_0;
    private String taskId;
    private String modelId;
    private final MLTaskType taskType;
    private FunctionName functionName;
    private MLTaskState state;
    private final MLInputDataType inputType;
    private Float progress;
    private final String outputIndex;
    private List<String> workerNodes;
    private final Instant createTime;
    private Instant lastUpdateTime;
    private String error;
    private User user;
    private boolean async;
    private Map<String, Object> remoteJob;
    private String tenantId;

    public MLTask(String taskId, String modelId, MLTaskType taskType, FunctionName functionName, MLTaskState state, MLInputDataType inputType, Float progress, String outputIndex, List<String> workerNodes, Instant createTime, Instant lastUpdateTime, String error, User user, boolean async, Map<String, Object> remoteJob, String tenantId) {
        this.taskId = taskId;
        this.modelId = modelId;
        this.taskType = taskType;
        this.functionName = functionName;
        this.state = state;
        this.inputType = inputType;
        this.progress = progress;
        this.outputIndex = outputIndex;
        this.workerNodes = workerNodes;
        this.createTime = createTime;
        this.lastUpdateTime = lastUpdateTime;
        this.error = error;
        this.user = user;
        this.async = async;
        this.remoteJob = remoteJob;
        this.tenantId = tenantId;
    }

    public MLTask(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.taskId = input.readOptionalString();
        this.modelId = input.readOptionalString();
        this.taskType = (MLTaskType)input.readEnum(MLTaskType.class);
        this.functionName = (FunctionName)input.readEnum(FunctionName.class);
        this.state = (MLTaskState)input.readEnum(MLTaskState.class);
        this.inputType = input.readBoolean() ? (MLInputDataType)input.readEnum(MLInputDataType.class) : null;
        this.progress = input.readOptionalFloat();
        this.outputIndex = input.readOptionalString();
        this.workerNodes = input.readStringList();
        this.createTime = input.readInstant();
        this.lastUpdateTime = input.readInstant();
        this.error = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
        this.async = input.readBoolean();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_BATCH_PREDICTION_JOB) && input.readBoolean()) {
            this.remoteJob = input.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    public MLTask setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public MLTask setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public MLTask setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
        return this;
    }

    public MLTask setState(MLTaskState state) {
        this.state = state;
        return this;
    }

    public MLTask setWorkerNodes(List<String> workerNodes) {
        this.workerNodes = workerNodes;
        return this;
    }

    public MLTask setError(String error) {
        this.error = error;
        return this;
    }

    public MLTask setRemoteJob(Map<String, Object> remoteJob) {
        this.remoteJob = remoteJob;
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public MLTaskType getTaskType() {
        return this.taskType;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public MLTaskState getState() {
        return this.state;
    }

    public MLInputDataType getInputType() {
        return this.inputType;
    }

    public Float getProgress() {
        return this.progress;
    }

    public String getOutputIndex() {
        return this.outputIndex;
    }

    public List<String> getWorkerNodes() {
        return this.workerNodes;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getError() {
        return this.error;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isAsync() {
        return this.async;
    }

    public Map<String, Object> getRemoteJob() {
        return this.remoteJob;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Builder toBuilder() {
        return new Builder().taskId(this.taskId).modelId(this.modelId).taskType(this.taskType).functionName(this.functionName).state(this.state).inputType(this.inputType).progress(this.progress).outputIndex(this.outputIndex).workerNodes(this.workerNodes).createTime(this.createTime).lastUpdateTime(this.lastUpdateTime).error(this.error).user(this.user).async(this.async).remoteJob(this.remoteJob).tenantId(this.tenantId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.modelId);
        out.writeEnum((Enum)this.taskType);
        out.writeEnum((Enum)this.functionName);
        out.writeEnum((Enum)this.state);
        if (this.inputType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.inputType);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalFloat(this.progress);
        out.writeOptionalString(this.outputIndex);
        out.writeStringCollection(this.workerNodes);
        out.writeInstant(this.createTime);
        out.writeInstant(this.lastUpdateTime);
        out.writeOptionalString(this.error);
        if (this.user != null) {
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.async);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_BATCH_PREDICTION_JOB)) {
            if (this.remoteJob != null) {
                out.writeBoolean(true);
                out.writeMap(this.remoteJob, StreamOutput::writeString, StreamOutput::writeGenericValue);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.taskType != null) {
            builder.field(TASK_TYPE_FIELD, (Object)this.taskType);
        }
        if (this.functionName != null) {
            builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        }
        if (this.state != null) {
            builder.field(STATE_FIELD, (Object)this.state);
        }
        if (this.inputType != null) {
            builder.field(INPUT_TYPE_FIELD, (Object)this.inputType);
        }
        if (this.progress != null) {
            builder.field(PROGRESS_FIELD, this.progress);
        }
        if (this.outputIndex != null) {
            builder.field(OUTPUT_INDEX_FIELD, this.outputIndex);
        }
        if (this.workerNodes != null) {
            builder.field(WORKER_NODE_FIELD, this.workerNodes);
        }
        if (this.createTime != null) {
            builder.field(CREATE_TIME_FIELD, this.createTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.error != null) {
            builder.field(ERROR_FIELD, this.error);
        }
        if (this.user != null) {
            builder.field("user", (ToXContent)this.user);
        }
        builder.field(IS_ASYNC_TASK_FIELD, this.async);
        if (this.remoteJob != null) {
            builder.field(REMOTE_JOB_FIELD, this.remoteJob);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        return builder.endObject();
    }

    public static MLTask fromStream(StreamInput in) throws IOException {
        return new MLTask(in);
    }

    public static MLTask parse(XContentParser parser) throws IOException {
        String taskId = null;
        String modelId = null;
        MLTaskType taskType = null;
        FunctionName functionName = null;
        MLTaskState state = null;
        MLInputDataType inputType = null;
        Float progress = null;
        String outputIndex = null;
        List<Object> workerNodes = null;
        Instant createTime = null;
        Instant lastUpdateTime = null;
        String error = null;
        User user = null;
        boolean async = false;
        Map remoteJob = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block36: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "task_id": {
                    taskId = parser.text();
                    continue block36;
                }
                case "model_id": {
                    modelId = parser.text();
                    continue block36;
                }
                case "task_type": {
                    taskType = MLTaskType.valueOf(parser.text());
                    continue block36;
                }
                case "function_name": {
                    functionName = FunctionName.from(parser.text());
                    continue block36;
                }
                case "state": {
                    state = MLTaskState.valueOf(parser.text());
                    continue block36;
                }
                case "input_type": {
                    inputType = MLInputDataType.valueOf(parser.text());
                    continue block36;
                }
                case "progress": {
                    progress = Float.valueOf(parser.floatValue());
                    continue block36;
                }
                case "output_index": {
                    outputIndex = parser.text();
                    continue block36;
                }
                case "worker_node": {
                    if (XContentParser.Token.START_ARRAY == parser.currentToken()) {
                        workerNodes = new ArrayList();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            workerNodes.add(parser.text());
                        }
                        continue block36;
                    }
                    String[] nodes = parser.text().split(",");
                    workerNodes = Arrays.asList(nodes);
                    continue block36;
                }
                case "create_time": {
                    createTime = Instant.ofEpochMilli(parser.longValue());
                    continue block36;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block36;
                }
                case "error": {
                    error = parser.text();
                    continue block36;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block36;
                }
                case "is_async": {
                    async = parser.booleanValue();
                    continue block36;
                }
                case "remote_job": {
                    remoteJob = parser.map();
                    continue block36;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block36;
                }
            }
            parser.skipChildren();
        }
        return MLTask.builder().taskId(taskId).modelId(modelId).taskType(taskType).functionName(functionName).state(state).inputType(inputType).progress(progress).outputIndex(outputIndex).workerNodes(workerNodes).createTime(createTime).lastUpdateTime(lastUpdateTime).error(error).user(user).async(async).remoteJob(remoteJob).tenantId(tenantId).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLTask mlTask = (MLTask)o;
        return this.async == mlTask.async && Objects.equals(this.taskId, mlTask.taskId) && Objects.equals(this.modelId, mlTask.modelId) && this.taskType == mlTask.taskType && this.functionName == mlTask.functionName && this.state == mlTask.state && this.inputType == mlTask.inputType && Objects.equals(this.progress, mlTask.progress) && Objects.equals(this.outputIndex, mlTask.outputIndex) && Objects.equals(this.workerNodes, mlTask.workerNodes) && Objects.equals(this.createTime, mlTask.createTime) && Objects.equals(this.lastUpdateTime, mlTask.lastUpdateTime) && Objects.equals(this.error, mlTask.error) && Objects.equals(this.user, mlTask.user) && Objects.equals(this.remoteJob, mlTask.remoteJob) && Objects.equals(this.tenantId, mlTask.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.modelId, this.taskType, this.functionName, this.state, this.inputType, this.progress, this.outputIndex, this.workerNodes, this.createTime, this.lastUpdateTime, this.error, this.user, this.async, this.remoteJob, this.tenantId});
    }

    public static class Builder {
        private String taskId;
        private String modelId;
        private MLTaskType taskType;
        private FunctionName functionName;
        private MLTaskState state;
        private MLInputDataType inputType;
        private Float progress;
        private String outputIndex;
        private List<String> workerNodes;
        private Instant createTime;
        private Instant lastUpdateTime;
        private String error;
        private User user;
        private boolean async;
        private Map<String, Object> remoteJob;
        private String tenantId;

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder taskType(MLTaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder state(MLTaskState state) {
            this.state = state;
            return this;
        }

        public Builder inputType(MLInputDataType inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder progress(Float progress) {
            this.progress = progress;
            return this;
        }

        public Builder outputIndex(String outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public Builder workerNodes(List<String> workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        public Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder remoteJob(Map<String, Object> remoteJob) {
            this.remoteJob = remoteJob;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLTask build() {
            return new MLTask(this.taskId, this.modelId, this.taskType, this.functionName, this.state, this.inputType, this.progress, this.outputIndex, this.workerNodes, this.createTime, this.lastUpdateTime, this.error, this.user, this.async, this.remoteJob, this.tenantId);
        }
    }
}

