/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.controller;

import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.transport.controller.MLDeployControllerNodesResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLDeployControllerNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(MLDeployControllerNodesResponse.class);
    private Map<String, String> controllerDeployStatus;

    public MLDeployControllerNodeResponse(DiscoveryNode node, Map<String, String> controllerDeployStatus) {
        super(node);
        this.controllerDeployStatus = controllerDeployStatus;
    }

    public MLDeployControllerNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.controllerDeployStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLDeployControllerNodeResponse readStats(StreamInput in) throws IOException {
        return new MLDeployControllerNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (!this.isControllerDeployStatusEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.controllerDeployStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (!this.isControllerDeployStatusEmpty()) {
            for (Map.Entry<String, String> stat : this.controllerDeployStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }

    public boolean isControllerDeployStatusEmpty() {
        return this.controllerDeployStatus == null || this.controllerDeployStatus.isEmpty();
    }

    public Map<String, String> getControllerDeployStatus() {
        return this.controllerDeployStatus;
    }
}

