/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.deploy;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.task.MLTask;
import java.io.IOException;
import java.util.Objects;

public class MLDeployModelInput
implements Writeable {
    private String modelId;
    private String tenantId;
    private String taskId;
    private String modelContentHash;
    private Integer nodeCount;
    private String coordinatingNodeId;
    private Boolean isDeployToAllNodes;
    private MLTask mlTask;

    public MLDeployModelInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.modelId = in.readString();
        this.taskId = in.readString();
        this.modelContentHash = in.readOptionalString();
        this.nodeCount = in.readInt();
        this.coordinatingNodeId = in.readString();
        this.isDeployToAllNodes = in.readOptionalBoolean();
        this.mlTask = new MLTask(in);
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public MLDeployModelInput(String modelId, String taskId, String modelContentHash, Integer nodeCount, String coordinatingNodeId, Boolean isDeployToAllNodes, MLTask mlTask, String tenantId) {
        this.modelId = modelId;
        this.taskId = taskId;
        this.modelContentHash = modelContentHash;
        this.nodeCount = nodeCount;
        this.coordinatingNodeId = coordinatingNodeId;
        this.isDeployToAllNodes = isDeployToAllNodes;
        this.mlTask = mlTask;
        this.tenantId = tenantId;
    }

    public MLDeployModelInput() {
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.modelId);
        out.writeString(this.taskId);
        out.writeOptionalString(this.modelContentHash);
        out.writeInt(this.nodeCount.intValue());
        out.writeString(this.coordinatingNodeId);
        out.writeOptionalBoolean(this.isDeployToAllNodes);
        this.mlTask.writeTo(out);
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getModelContentHash() {
        return this.modelContentHash;
    }

    public void setModelContentHash(String modelContentHash) {
        this.modelContentHash = modelContentHash;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
    }

    public String getCoordinatingNodeId() {
        return this.coordinatingNodeId;
    }

    public void setCoordinatingNodeId(String coordinatingNodeId) {
        this.coordinatingNodeId = coordinatingNodeId;
    }

    public Boolean getIsDeployToAllNodes() {
        return this.isDeployToAllNodes;
    }

    public void setDeployToAllNodes(Boolean deployToAllNodes) {
        this.isDeployToAllNodes = deployToAllNodes;
    }

    public MLTask getMlTask() {
        return this.mlTask;
    }

    public void setMlTask(MLTask mlTask) {
        this.mlTask = mlTask;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLDeployModelInput that = (MLDeployModelInput)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.modelContentHash, that.modelContentHash) && Objects.equals(this.nodeCount, that.nodeCount) && Objects.equals(this.coordinatingNodeId, that.coordinatingNodeId) && Objects.equals(this.isDeployToAllNodes, that.isDeployToAllNodes) && Objects.equals(this.mlTask, that.mlTask);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.tenantId, this.taskId, this.modelContentHash, this.nodeCount, this.coordinatingNodeId, this.isDeployToAllNodes, this.mlTask);
    }

    public String toString() {
        return "MLDeployModelInput{modelId='" + this.modelId + "', tenantId='" + this.tenantId + "', taskId='" + this.taskId + "', modelContentHash='" + this.modelContentHash + "', nodeCount=" + this.nodeCount + ", coordinatingNodeId='" + this.coordinatingNodeId + "', isDeployToAllNodes=" + this.isDeployToAllNodes + ", mlTask=" + String.valueOf(this.mlTask) + "}";
    }

    public static class Builder {
        private String modelId;
        private String tenantId;
        private String taskId;
        private String modelContentHash;
        private Integer nodeCount;
        private String coordinatingNodeId;
        private Boolean isDeployToAllNodes;
        private MLTask mlTask;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder modelContentHash(String modelContentHash) {
            this.modelContentHash = modelContentHash;
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public Builder coordinatingNodeId(String coordinatingNodeId) {
            this.coordinatingNodeId = coordinatingNodeId;
            return this;
        }

        public Builder deployToAllNodes(Boolean deployToAllNodes) {
            this.isDeployToAllNodes = deployToAllNodes;
            return this;
        }

        public Builder mlTask(MLTask mlTask) {
            this.mlTask = mlTask;
            return this;
        }

        public MLDeployModelInput build() {
            return new MLDeployModelInput(this.modelId, this.taskId, this.modelContentHash, this.nodeCount, this.coordinatingNodeId, this.isDeployToAllNodes, this.mlTask, this.tenantId);
        }
    }
}

