/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.deploy;

import io.skylite.Version;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.transport.MLTaskRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class MLDeployModelRequest
extends MLTaskRequest {
    private static final String NODE_IDS_FIELD = "node_ids";
    private final String modelId;
    private final String[] modelNodeIds;
    private final boolean async;
    private final boolean isUserInitiatedDeployRequest;
    private final String tenantId;

    public MLDeployModelRequest(String modelId, String tenantId, String[] modelNodeIds, boolean async, boolean dispatchTask, boolean isUserInitiatedDeployRequest) {
        super(dispatchTask);
        this.modelId = modelId;
        this.tenantId = tenantId;
        this.modelNodeIds = modelNodeIds;
        this.async = async;
        this.isUserInitiatedDeployRequest = isUserInitiatedDeployRequest;
    }

    public MLDeployModelRequest(String modelId, String tenantId, boolean async) {
        this(modelId, tenantId, null, async, true, true);
    }

    public MLDeployModelRequest(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.modelId = in.readString();
        this.modelNodeIds = in.readOptionalStringArray();
        this.async = in.readBoolean();
        this.isUserInitiatedDeployRequest = in.readBoolean();
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.modelId == null) {
            exception = ValidateActions.addValidationError((String)"ML model id can't be null", exception);
        }
        return exception;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String[] getModelNodeIds() {
        return this.modelNodeIds;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isUserInitiatedDeployRequest() {
        return this.isUserInitiatedDeployRequest;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.modelId);
        out.writeOptionalStringArray(this.modelNodeIds);
        out.writeBoolean(this.async);
        out.writeBoolean(this.isUserInitiatedDeployRequest);
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public static MLDeployModelRequest parse(XContentParser parser, String modelId, String tenantId) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        ArrayList<String> nodeIdList = new ArrayList<String>();
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        nodeIdList.add(parser.text());
                    }
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        String[] nodeIds = nodeIdList.toArray(new String[0]);
        return new MLDeployModelRequest(modelId, tenantId, nodeIds, false, true, true);
    }

    /*
     * Exception decompiling
     */
    public static MLDeployModelRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "MLDeployModelRequest{modelId='" + this.modelId + "', modelNodeIds=" + Arrays.toString(this.modelNodeIds) + ", async=" + this.async + ", isUserInitiatedDeployRequest=" + this.isUserInitiatedDeployRequest + ", tenantId='" + this.tenantId + "'}";
    }

    public static class Builder {
        private String modelId;
        private String[] modelNodeIds;
        private boolean async;
        private boolean isUserInitiatedDeployRequest;
        private boolean dispatchTask;
        private String tenantId;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder modelNodeIds(String[] modelNodeIds) {
            this.modelNodeIds = modelNodeIds;
            return this;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder userInitiatedDeployRequest(boolean userInitiatedDeployRequest) {
            this.isUserInitiatedDeployRequest = userInitiatedDeployRequest;
            return this;
        }

        public Builder dispatchTask(boolean dispatchTask) {
            this.dispatchTask = dispatchTask;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLDeployModelRequest build() {
            return new MLDeployModelRequest(this.modelId, this.tenantId, this.modelNodeIds, this.async, this.dispatchTask, this.isUserInitiatedDeployRequest);
        }
    }
}

