/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.forward;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.transport.forward.MLForwardRequestType;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLForwardInput
implements Writeable {
    private static final Logger log = LogManager.getLogger(MLForwardInput.class);
    private String taskId;
    private String modelId;
    private String tenantId;
    private String workerNodeId;
    private MLForwardRequestType requestType;
    private MLTask mlTask;
    private MLInput modelInput;
    private String error;
    private String[] workerNodes;
    private MLRegisterModelInput registerModelInput;

    public MLForwardInput(String taskId, String modelId, String tenantId, String workerNodeId, MLForwardRequestType requestType, MLTask mlTask, MLInput modelInput, String error, String[] workerNodes, MLRegisterModelInput registerModelInput) {
        this.taskId = taskId;
        this.modelId = modelId;
        this.tenantId = tenantId;
        this.workerNodeId = workerNodeId;
        this.requestType = requestType;
        this.mlTask = mlTask;
        this.modelInput = modelInput;
        this.error = error;
        this.workerNodes = workerNodes;
        this.registerModelInput = registerModelInput;
    }

    public MLForwardInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.taskId = in.readOptionalString();
        this.modelId = in.readOptionalString();
        this.workerNodeId = in.readOptionalString();
        this.requestType = (MLForwardRequestType)in.readEnum(MLForwardRequestType.class);
        if (in.readBoolean()) {
            this.mlTask = new MLTask(in);
        }
        if (in.readBoolean()) {
            this.modelInput = new MLInput(in);
        }
        this.error = in.readOptionalString();
        this.workerNodes = in.readOptionalStringArray();
        if (in.readBoolean()) {
            this.registerModelInput = new MLRegisterModelInput(in);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.modelId);
        out.writeOptionalString(this.workerNodeId);
        out.writeEnum((Enum)this.requestType);
        if (this.mlTask != null) {
            out.writeBoolean(true);
            this.mlTask.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelInput != null) {
            out.writeBoolean(true);
            this.modelInput.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.error);
        out.writeOptionalStringArray(this.workerNodes);
        if (this.registerModelInput != null) {
            out.writeBoolean(true);
            this.registerModelInput.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getWorkerNodeId() {
        return this.workerNodeId;
    }

    public MLForwardRequestType getRequestType() {
        return this.requestType;
    }

    public MLTask getMlTask() {
        return this.mlTask;
    }

    public MLInput getModelInput() {
        return this.modelInput;
    }

    public String getError() {
        return this.error;
    }

    public String[] getWorkerNodes() {
        return this.workerNodes;
    }

    public MLRegisterModelInput getRegisterModelInput() {
        return this.registerModelInput;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setWorkerNodeId(String workerNodeId) {
        this.workerNodeId = workerNodeId;
    }

    public void setRequestType(MLForwardRequestType requestType) {
        this.requestType = requestType;
    }

    public void setMlTask(MLTask mlTask) {
        this.mlTask = mlTask;
    }

    public void setModelInput(MLInput modelInput) {
        this.modelInput = modelInput;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setWorkerNodes(String[] workerNodes) {
        this.workerNodes = workerNodes;
    }

    public void setRegisterModelInput(MLRegisterModelInput registerModelInput) {
        this.registerModelInput = registerModelInput;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().taskId(this.taskId).modelId(this.modelId).tenantId(this.tenantId).workerNodeId(this.workerNodeId).requestType(this.requestType).mlTask(this.mlTask).modelInput(this.modelInput).error(this.error).workerNodes(this.workerNodes).registerModelInput(this.registerModelInput);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLForwardInput that = (MLForwardInput)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.workerNodeId, that.workerNodeId) && this.requestType == that.requestType && Objects.equals(this.mlTask, that.mlTask) && Objects.equals(this.modelInput, that.modelInput) && Objects.equals(this.error, that.error) && Objects.deepEquals(this.workerNodes, that.workerNodes) && Objects.equals(this.registerModelInput, that.registerModelInput);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.modelId, this.tenantId, this.workerNodeId, this.requestType, this.mlTask, this.modelInput, this.error, Arrays.hashCode(this.workerNodes), this.registerModelInput});
    }

    public String toString() {
        return "MLForwardInput{taskId='" + this.taskId + "', modelId='" + this.modelId + "', tenantId='" + this.tenantId + "', workerNodeId='" + this.workerNodeId + "', requestType=" + String.valueOf((Object)this.requestType) + ", mlTask=" + String.valueOf(this.mlTask) + ", modelInput=" + String.valueOf(this.modelInput) + ", error='" + this.error + "', workerNodes=" + Arrays.toString(this.workerNodes) + ", registerModelInput=" + String.valueOf(this.registerModelInput) + "}";
    }

    public static class Builder {
        private String taskId;
        private String modelId;
        private String tenantId;
        private String workerNodeId;
        private MLForwardRequestType requestType;
        private MLTask mlTask;
        private MLInput modelInput;
        private String error;
        private String[] workerNodes;
        private MLRegisterModelInput registerModelInput;

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder workerNodeId(String workerNodeId) {
            this.workerNodeId = workerNodeId;
            return this;
        }

        public Builder requestType(MLForwardRequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder mlTask(MLTask mlTask) {
            this.mlTask = mlTask;
            return this;
        }

        public Builder modelInput(MLInput modelInput) {
            this.modelInput = modelInput;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder workerNodes(String[] workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        public Builder registerModelInput(MLRegisterModelInput registerModelInput) {
            this.registerModelInput = registerModelInput;
            return this;
        }

        public MLForwardInput build() {
            return new MLForwardInput(this.taskId, this.modelId, this.tenantId, this.workerNodeId, this.requestType, this.mlTask, this.modelInput, this.error, this.workerNodes, this.registerModelInput);
        }
    }
}

