/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.model_group;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.CommonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class MLRegisterModelGroupInput
implements ToXContentObject,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String MODEL_ACCESS_MODE = "access_mode";
    public static final String ADD_ALL_BACKEND_ROLES = "add_all_backend_roles";
    private String name;
    private String description;
    private List<String> backendRoles;
    private AccessMode modelAccessMode;
    private Boolean isAddAllBackendRoles;
    private String tenantId;

    public MLRegisterModelGroupInput(String name, String description, List<String> backendRoles, AccessMode modelAccessMode, Boolean isAddAllBackendRoles, String tenantId) {
        this.name = Objects.requireNonNull(name, "model group name must not be null");
        this.description = description;
        this.backendRoles = backendRoles;
        this.modelAccessMode = modelAccessMode;
        this.isAddAllBackendRoles = isAddAllBackendRoles;
        this.tenantId = tenantId;
    }

    public MLRegisterModelGroupInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.name = in.readString();
        this.description = in.readOptionalString();
        this.backendRoles = in.readOptionalStringList();
        if (in.readBoolean()) {
            this.modelAccessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.isAddAllBackendRoles = in.readOptionalBoolean();
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelAccessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelAccessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isAddAllBackendRoles);
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.backendRoles != null && this.backendRoles.size() > 0) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.modelAccessMode != null) {
            builder.field(MODEL_ACCESS_MODE, (Object)this.modelAccessMode);
        }
        if (this.isAddAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES, this.isAddAllBackendRoles);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelGroupInput parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        ArrayList<String> backendRoles = null;
        AccessMode modelAccessMode = null;
        Boolean isAddAllBackendRoles = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block16;
                }
                case "description": {
                    description = parser.text();
                    continue block16;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block16;
                }
                case "access_mode": {
                    modelAccessMode = AccessMode.from(parser.text().toLowerCase(Locale.ROOT));
                    continue block16;
                }
                case "add_all_backend_roles": {
                    isAddAllBackendRoles = parser.booleanValue();
                    continue block16;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelGroupInput(name, description, backendRoles, modelAccessMode, isAddAllBackendRoles, tenantId);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public AccessMode getModelAccessMode() {
        return this.modelAccessMode;
    }

    public Boolean getIsAddAllBackendRoles() {
        return this.isAddAllBackendRoles;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    public void setModelAccessMode(AccessMode modelAccessMode) {
        this.modelAccessMode = modelAccessMode;
    }

    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.isAddAllBackendRoles = addAllBackendRoles;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).description(this.description).backendRoles(this.backendRoles).modelAccessMode(this.modelAccessMode).isAddAllBackendRoles(this.isAddAllBackendRoles).tenantId(this.tenantId);
    }

    public String toString() {
        return "MLRegisterModelGroupInput{name='" + this.name + "', description='" + this.description + "', backendRoles=" + String.valueOf(this.backendRoles) + ", modelAccessMode=" + String.valueOf((Object)this.modelAccessMode) + ", isAddAllBackendRoles=" + this.isAddAllBackendRoles + ", tenantId='" + this.tenantId + "'}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLRegisterModelGroupInput that = (MLRegisterModelGroupInput)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.backendRoles, that.backendRoles) && this.modelAccessMode == that.modelAccessMode && Objects.equals(this.isAddAllBackendRoles, that.isAddAllBackendRoles) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.backendRoles, this.modelAccessMode, this.isAddAllBackendRoles, this.tenantId});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private List<String> backendRoles;
        private AccessMode modelAccessMode;
        private Boolean isAddAllBackendRoles;
        private String tenantId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder modelAccessMode(AccessMode modelAccessMode) {
            this.modelAccessMode = modelAccessMode;
            return this;
        }

        public Builder isAddAllBackendRoles(Boolean addAllBackendRoles) {
            this.isAddAllBackendRoles = addAllBackendRoles;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLRegisterModelGroupInput build() {
            return new MLRegisterModelGroupInput(this.name, this.description, this.backendRoles, this.modelAccessMode, this.isAddAllBackendRoles, this.tenantId);
        }
    }
}

