/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.model_group;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.CommonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class MLUpdateModelGroupInput
implements ToXContentObject,
Writeable {
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String MODEL_ACCESS_MODE = "access_mode";
    public static final String ADD_ALL_BACKEND_ROLES_FIELD = "add_all_backend_roles";
    private String modelGroupID;
    private String name;
    private String description;
    private List<String> backendRoles;
    private AccessMode modelAccessMode;
    private Boolean isAddAllBackendRoles;
    private String tenantId;

    public MLUpdateModelGroupInput(String modelGroupID, String name, String description, List<String> backendRoles, AccessMode modelAccessMode, Boolean isAddAllBackendRoles, String tenantId) {
        this.modelGroupID = modelGroupID;
        this.name = name;
        this.description = description;
        this.backendRoles = backendRoles;
        this.modelAccessMode = modelAccessMode;
        this.isAddAllBackendRoles = isAddAllBackendRoles;
        this.tenantId = tenantId;
    }

    public MLUpdateModelGroupInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.modelGroupID = in.readString();
        this.name = in.readOptionalString();
        this.description = in.readOptionalString();
        this.backendRoles = in.readOptionalStringList();
        if (in.readBoolean()) {
            this.modelAccessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.isAddAllBackendRoles = in.readOptionalBoolean();
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupID);
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.backendRoles != null && this.backendRoles.size() > 0) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.modelAccessMode != null) {
            builder.field(MODEL_ACCESS_MODE, (Object)this.modelAccessMode);
        }
        if (this.isAddAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES_FIELD, this.isAddAllBackendRoles);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.modelGroupID);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelAccessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelAccessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isAddAllBackendRoles);
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public static MLUpdateModelGroupInput parse(XContentParser parser) throws IOException {
        String modelGroupID = null;
        String name = null;
        String description = null;
        ArrayList<String> backendRoles = null;
        AccessMode modelAccessMode = null;
        Boolean isAddAllBackendRoles = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_group_id": {
                    modelGroupID = parser.text();
                    continue block18;
                }
                case "name": {
                    name = parser.text();
                    continue block18;
                }
                case "description": {
                    description = parser.text();
                    continue block18;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block18;
                }
                case "access_mode": {
                    modelAccessMode = AccessMode.from(parser.text().toLowerCase(Locale.ROOT));
                    continue block18;
                }
                case "add_all_backend_roles": {
                    isAddAllBackendRoles = parser.booleanValue();
                    continue block18;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return new MLUpdateModelGroupInput(modelGroupID, name, description, backendRoles, modelAccessMode, isAddAllBackendRoles, tenantId);
    }

    public String getModelGroupID() {
        return this.modelGroupID;
    }

    public void setModelGroupID(String modelGroupID) {
        this.modelGroupID = modelGroupID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    public AccessMode getModelAccessMode() {
        return this.modelAccessMode;
    }

    public void setModelAccessMode(AccessMode modelAccessMode) {
        this.modelAccessMode = modelAccessMode;
    }

    public Boolean getIsAddAllBackendRoles() {
        return this.isAddAllBackendRoles;
    }

    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.isAddAllBackendRoles = addAllBackendRoles;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Builder toBuilder() {
        return new Builder().modelGroupID(this.modelGroupID).name(this.name).description(this.description).backendRoles(this.backendRoles).modelAccessMode(this.modelAccessMode).isAddAllBackendRoles(this.isAddAllBackendRoles).tenantId(this.tenantId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MLUpdateModelGroupInput{modelGroupID='" + this.modelGroupID + "', name='" + this.name + "', description='" + this.description + "', backendRoles=" + String.valueOf(this.backendRoles) + ", modelAccessMode=" + String.valueOf((Object)this.modelAccessMode) + ", isAddAllBackendRoles=" + this.isAddAllBackendRoles + ", tenantId='" + this.tenantId + "'}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLUpdateModelGroupInput that = (MLUpdateModelGroupInput)o;
        return Objects.equals(this.modelGroupID, that.modelGroupID) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.backendRoles, that.backendRoles) && this.modelAccessMode == that.modelAccessMode && Objects.equals(this.isAddAllBackendRoles, that.isAddAllBackendRoles) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelGroupID, this.name, this.description, this.backendRoles, this.modelAccessMode, this.isAddAllBackendRoles, this.tenantId});
    }

    public static class Builder {
        private String modelGroupID;
        private String name;
        private String description;
        private List<String> backendRoles;
        private AccessMode modelAccessMode;
        private Boolean isAddAllBackendRoles;
        private String tenantId;

        public Builder modelGroupID(String modelGroupID) {
            this.modelGroupID = modelGroupID;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder modelAccessMode(AccessMode modelAccessMode) {
            this.modelAccessMode = modelAccessMode;
            return this;
        }

        public Builder isAddAllBackendRoles(Boolean addAllBackendRoles) {
            this.isAddAllBackendRoles = addAllBackendRoles;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLUpdateModelGroupInput build() {
            return new MLUpdateModelGroupInput(this.modelGroupID, this.name, this.description, this.backendRoles, this.modelAccessMode, this.isAddAllBackendRoles, this.tenantId);
        }
    }
}

