/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.prediction;

import io.skylite.Version;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.security.auth.User;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.transport.MLTaskRequest;
import java.io.IOException;

public class MLPredictionTaskRequest
extends MLTaskRequest {
    private String modelId;
    private MLInput mlInput;
    private String tenantId;
    private User user;

    public MLPredictionTaskRequest(String modelId, MLInput mlInput, boolean dispatchTask, User user, String tenantId) {
        super(dispatchTask);
        this.mlInput = mlInput;
        this.modelId = modelId;
        this.user = user;
        this.tenantId = tenantId;
    }

    public MLPredictionTaskRequest(String modelId, MLInput mlInput) {
        this(modelId, mlInput, true, null, null);
    }

    public MLPredictionTaskRequest(String modelId, MLInput mlInput, User user, String tenantId) {
        this(modelId, mlInput, true, user, tenantId);
    }

    public MLPredictionTaskRequest(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.modelId = in.readOptionalString();
        this.mlInput = new MLInput(in);
        if (in.readBoolean()) {
            this.user = new User(in);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.modelId);
        this.mlInput.writeTo(out);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.mlInput == null) {
            exception = ValidateActions.addValidationError((String)"ML input can't be null", exception);
        } else if (this.mlInput.getInputDataset() == null) {
            exception = ValidateActions.addValidationError((String)"input data can't be null", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    /*
     * Exception decompiling
     */
    public static MLPredictionTaskRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getModelId() {
        return this.modelId;
    }

    public MLInput getMlInput() {
        return this.mlInput;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MLPredictionTaskRequest{modelId='" + this.modelId + "', mlInput=" + String.valueOf(this.mlInput) + ", tenantId='" + this.tenantId + "', user=" + String.valueOf(this.user) + ", dispatchTask=" + this.dispatchTask + ", requestID='" + this.requestID + "'}";
    }

    public static class Builder {
        private String modelId;
        private MLInput mlInput;
        private boolean dispatchTask;
        private String tenantId;
        private User user;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder mlInput(MLInput mlInput) {
            this.mlInput = mlInput;
            return this;
        }

        public Builder dispatchTask(boolean dispatchTask) {
            this.dispatchTask = dispatchTask;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public MLPredictionTaskRequest build() {
            return new MLPredictionTaskRequest(this.modelId, this.mlInput, this.dispatchTask, this.user, this.tenantId);
        }
    }
}

