/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.register;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.controller.MLRateLimiter;
import io.skylite.ml.common.model.Guardrails;
import io.skylite.ml.common.model.MLDeploySetting;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelConfig;
import io.skylite.ml.common.model.MLModelFormat;
import io.skylite.ml.common.model.MetricsCorrelationModelConfig;
import io.skylite.ml.common.model.QuestionAnsweringModelConfig;
import io.skylite.ml.common.model.TextEmbeddingModelConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class MLRegisterModelInput
implements ToXContentObject,
Writeable {
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String NAME_FIELD = "name";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String VERSION_FIELD = "version";
    public static final String IS_ENABLED_FIELD = "is_enabled";
    public static final String RATE_LIMITER_FIELD = "rate_limiter";
    public static final String URL_FIELD = "url";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_SETTING_FIELD = "deploy_setting";
    public static final String DEPLOY_MODEL_FIELD = "deploy_model";
    public static final String MODEL_NODE_IDS_FIELD = "model_node_ids";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String CONNECTOR_ID_FIELD = "connector_id";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String ACCESS_MODE_FIELD = "access_mode";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ADD_ALL_BACKEND_ROLES_FIELD = "add_all_backend_roles";
    public static final String DOES_VERSION_CREATE_MODEL_GROUP = "does_version_create_model_group";
    public static final String GUARDRAILS_FIELD = "guardrails";
    public static final OpenSearchVersion MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP = CommonValue.VERSION_2_11_0;
    public static final OpenSearchVersion MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK = CommonValue.VERSION_2_12_0;
    public static final OpenSearchVersion MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY = CommonValue.VERSION_2_13_0;
    public static final OpenSearchVersion MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE = CommonValue.VERSION_2_14_0;
    private FunctionName functionName;
    private String modelName;
    private String modelGroupId;
    private String version;
    private String description;
    private Boolean isEnabled;
    private MLRateLimiter rateLimiter;
    private String url;
    private String hashValue;
    private MLModelFormat modelFormat;
    private MLModelConfig modelConfig;
    private MLDeploySetting deploySetting;
    private boolean deployModel;
    private String[] modelNodeIds;
    private Connector connector;
    private String connectorId;
    private List<String> backendRoles;
    private Boolean addAllBackendRoles;
    private AccessMode accessMode;
    private Boolean doesVersionCreateModelGroup;
    private Boolean isHidden;
    private Guardrails guardrails;
    private Map<String, String> modelInterface;
    private String tenantId;

    public MLRegisterModelInput(FunctionName functionName, String modelName, String modelGroupId, String version, String description, Boolean isEnabled, MLRateLimiter rateLimiter, String url, String hashValue, MLModelFormat modelFormat, MLModelConfig modelConfig, MLDeploySetting deploySetting, boolean deployModel, String[] modelNodeIds, Connector connector, String connectorId, List<String> backendRoles, Boolean addAllBackendRoles, AccessMode accessMode, Boolean doesVersionCreateModelGroup, Boolean isHidden, Guardrails guardrails, Map<String, String> modelInterface, String tenantId) {
        this.functionName = Objects.requireNonNullElse(functionName, FunctionName.TEXT_EMBEDDING);
        if (modelName == null) {
            throw new IllegalArgumentException("model name is null");
        }
        if (functionName != FunctionName.REMOTE) {
            if (modelFormat == null) {
                throw new IllegalArgumentException("model format is null");
            }
            if (url != null && modelConfig == null && functionName != FunctionName.SPARSE_TOKENIZE && functionName != FunctionName.SPARSE_ENCODING) {
                throw new IllegalArgumentException("model config is null");
            }
        }
        this.modelName = modelName;
        this.modelGroupId = modelGroupId;
        this.version = version;
        this.description = description;
        this.isEnabled = isEnabled;
        this.rateLimiter = rateLimiter;
        this.url = url;
        this.hashValue = hashValue;
        this.modelFormat = modelFormat;
        this.modelConfig = modelConfig;
        this.deploySetting = deploySetting;
        this.deployModel = deployModel;
        this.modelNodeIds = modelNodeIds;
        this.connector = connector;
        this.connectorId = connectorId;
        this.backendRoles = backendRoles;
        this.addAllBackendRoles = addAllBackendRoles;
        this.accessMode = accessMode;
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
        this.isHidden = isHidden;
        this.guardrails = guardrails;
        this.modelInterface = modelInterface;
        this.tenantId = tenantId;
    }

    public MLRegisterModelInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.functionName = (FunctionName)in.readEnum(FunctionName.class);
        this.modelName = in.readString();
        this.modelGroupId = in.readOptionalString();
        this.version = in.readOptionalString();
        this.description = in.readOptionalString();
        this.url = in.readOptionalString();
        this.hashValue = in.readOptionalString();
        if (in.readBoolean()) {
            this.modelFormat = (MLModelFormat)in.readEnum(MLModelFormat.class);
        }
        if (in.readBoolean()) {
            this.modelConfig = this.functionName.equals((Object)FunctionName.METRICS_CORRELATION) ? new MetricsCorrelationModelConfig(in) : (this.functionName.equals((Object)FunctionName.QUESTION_ANSWERING) ? new QuestionAnsweringModelConfig(in) : new TextEmbeddingModelConfig(in));
        }
        this.deployModel = in.readBoolean();
        this.modelNodeIds = in.readOptionalStringArray();
        if (in.readBoolean()) {
            this.connector = Connector.fromStream(in);
        }
        this.connectorId = in.readOptionalString();
        if (in.readBoolean()) {
            this.backendRoles = in.readOptionalStringList();
        }
        this.addAllBackendRoles = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.accessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        if (streamInputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP)) {
            this.doesVersionCreateModelGroup = in.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isEnabled = in.readOptionalBoolean();
            if (in.readBoolean()) {
                this.rateLimiter = new MLRateLimiter(in);
            }
            this.isHidden = in.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (in.readBoolean()) {
                this.guardrails = new Guardrails(in);
            }
            if (in.readBoolean()) {
                this.deploySetting = new MLDeploySetting(in);
            }
        }
        if (streamInputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE) && in.readBoolean()) {
            this.modelInterface = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)OpenSearchVersion.fromId((int)2190099)) ? in.readOptionalString() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeEnum((Enum)this.functionName);
        out.writeString(this.modelName);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.url);
        out.writeOptionalString(this.hashValue);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.deployModel);
        out.writeOptionalStringArray(this.modelNodeIds);
        if (this.connector != null) {
            out.writeBoolean(true);
            this.connector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.connectorId);
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeOptionalStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.addAllBackendRoles);
        if (this.accessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.accessMode);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP)) {
            out.writeOptionalBoolean(this.doesVersionCreateModelGroup);
        }
        if (streamOutputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isEnabled);
            if (this.rateLimiter != null) {
                out.writeBoolean(true);
                this.rateLimiter.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalBoolean(this.isHidden);
        }
        if (streamOutputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (this.guardrails != null) {
                out.writeBoolean(true);
                this.guardrails.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.deploySetting != null) {
                out.writeBoolean(true);
                this.deploySetting.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE)) {
            if (this.modelInterface != null) {
                out.writeBoolean(true);
                out.writeMap(this.modelInterface, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)OpenSearchVersion.fromId((int)2190099))) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        builder.field(NAME_FIELD, this.modelName);
        if (this.version != null) {
            builder.field(VERSION_FIELD, this.version);
        }
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.isEnabled != null) {
            builder.field(IS_ENABLED_FIELD, this.isEnabled);
        }
        if (this.rateLimiter != null) {
            builder.field(RATE_LIMITER_FIELD, (ToXContent)this.rateLimiter);
        }
        if (this.url != null) {
            builder.field(URL_FIELD, this.url);
        }
        if (this.hashValue != null) {
            builder.field(MODEL_CONTENT_HASH_VALUE_FIELD, this.hashValue);
        }
        if (this.modelFormat != null) {
            builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        if (this.deploySetting != null) {
            builder.field(DEPLOY_SETTING_FIELD, (ToXContent)this.deploySetting);
        }
        builder.field(DEPLOY_MODEL_FIELD, this.deployModel);
        if (this.modelNodeIds != null) {
            builder.field(MODEL_NODE_IDS_FIELD, (Object)this.modelNodeIds);
        }
        if (this.connector != null) {
            builder.field(CONNECTOR_FIELD, (ToXContent)this.connector);
        }
        if (this.connectorId != null) {
            builder.field(CONNECTOR_ID_FIELD, this.connectorId);
        }
        if (this.backendRoles != null) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.addAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES_FIELD, this.addAllBackendRoles);
        }
        if (this.accessMode != null) {
            builder.field(ACCESS_MODE_FIELD, (Object)this.accessMode);
        }
        if (this.doesVersionCreateModelGroup != null) {
            builder.field(DOES_VERSION_CREATE_MODEL_GROUP, this.doesVersionCreateModelGroup);
        }
        if (this.isHidden != null) {
            builder.field("is_hidden", this.isHidden);
        }
        if (this.guardrails != null) {
            builder.field(GUARDRAILS_FIELD, (ToXContent)this.guardrails);
        }
        if (this.modelInterface != null) {
            builder.field("interface", this.modelInterface);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelInput parse(XContentParser parser, String modelName, String version, boolean deployModel) throws IOException {
        FunctionName functionName = null;
        String modelGroupId = null;
        Boolean isEnabled = null;
        MLRateLimiter rateLimiter = null;
        String url = null;
        String hashValue = null;
        String description = null;
        MLModelFormat modelFormat = null;
        MLModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        ArrayList<String> modelNodeIds = new ArrayList<String>();
        Connector connector = null;
        String connectorId = null;
        ArrayList<String> backendRoles = new ArrayList<String>();
        Boolean addAllBackendRoles = null;
        AccessMode accessMode = null;
        Boolean doesVersionCreateModelGroup = null;
        Boolean isHidden = null;
        Guardrails guardrails = null;
        Map modelInterface = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block46: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "function_name": {
                    functionName = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block46;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block46;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block46;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block46;
                }
                case "url": {
                    url = parser.text();
                    continue block46;
                }
                case "model_content_hash_value": {
                    hashValue = parser.text();
                    continue block46;
                }
                case "description": {
                    description = parser.text();
                    continue block46;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block46;
                }
                case "model_config": {
                    if (FunctionName.QUESTION_ANSWERING.equals((Object)functionName)) {
                        modelConfig = QuestionAnsweringModelConfig.parse(parser);
                        continue block46;
                    }
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block46;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block46;
                }
                case "connector": {
                    connector = Connector.createConnector(parser);
                    continue block46;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block46;
                }
                case "model_node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelNodeIds.add(parser.text());
                    }
                    continue block46;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block46;
                }
                case "add_all_backend_roles": {
                    addAllBackendRoles = parser.booleanValue();
                    continue block46;
                }
                case "is_hidden": {
                    isHidden = parser.booleanValue();
                    continue block46;
                }
                case "access_mode": {
                    accessMode = AccessMode.from(parser.text());
                    continue block46;
                }
                case "does_version_create_model_group": {
                    doesVersionCreateModelGroup = parser.booleanValue();
                    continue block46;
                }
                case "guardrails": {
                    guardrails = Guardrails.parse(parser);
                    continue block46;
                }
                case "interface": {
                    modelInterface = Strings.filteredParameterMap((Map)parser.map(), MLModel.allowedInterfaceFieldKeys);
                    continue block46;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block46;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelInput(functionName, modelName, modelGroupId, version, description, isEnabled, rateLimiter, url, hashValue, modelFormat, modelConfig, deploySetting, deployModel, modelNodeIds.toArray(new String[0]), connector, connectorId, backendRoles, addAllBackendRoles, accessMode, doesVersionCreateModelGroup, isHidden, guardrails, modelInterface, tenantId);
    }

    public static MLRegisterModelInput parse(XContentParser parser, boolean deployModel) throws IOException {
        FunctionName functionName = null;
        String name = null;
        String modelGroupId = null;
        String version = null;
        Boolean isEnabled = null;
        MLRateLimiter rateLimiter = null;
        String url = null;
        String hashValue = null;
        String description = null;
        MLModelFormat modelFormat = null;
        MLModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        ArrayList<String> modelNodeIds = new ArrayList<String>();
        Connector connector = null;
        String connectorId = null;
        ArrayList<String> backendRoles = new ArrayList<String>();
        AccessMode accessMode = null;
        Boolean addAllBackendRoles = null;
        Boolean doesVersionCreateModelGroup = null;
        Boolean isHidden = null;
        Guardrails guardrails = null;
        Map modelInterface = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block50: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "function_name": {
                    functionName = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block50;
                }
                case "name": {
                    name = parser.text();
                    continue block50;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block50;
                }
                case "version": {
                    version = parser.text();
                    continue block50;
                }
                case "description": {
                    description = parser.text();
                    continue block50;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block50;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block50;
                }
                case "url": {
                    url = parser.text();
                    continue block50;
                }
                case "connector": {
                    connector = Connector.createConnector(parser);
                    continue block50;
                }
                case "model_content_hash_value": {
                    hashValue = parser.text();
                    continue block50;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block50;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block50;
                }
                case "model_config": {
                    if (FunctionName.QUESTION_ANSWERING.equals((Object)functionName)) {
                        modelConfig = QuestionAnsweringModelConfig.parse(parser);
                        continue block50;
                    }
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block50;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block50;
                }
                case "model_node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelNodeIds.add(parser.text());
                    }
                    continue block50;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block50;
                }
                case "add_all_backend_roles": {
                    addAllBackendRoles = parser.booleanValue();
                    continue block50;
                }
                case "access_mode": {
                    accessMode = AccessMode.from(parser.text());
                    continue block50;
                }
                case "does_version_create_model_group": {
                    doesVersionCreateModelGroup = parser.booleanValue();
                    continue block50;
                }
                case "is_hidden": {
                    isHidden = parser.booleanValue();
                    continue block50;
                }
                case "guardrails": {
                    guardrails = Guardrails.parse(parser);
                    continue block50;
                }
                case "interface": {
                    modelInterface = Strings.filteredParameterMap((Map)parser.map(), MLModel.allowedInterfaceFieldKeys);
                    continue block50;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block50;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelInput(functionName, name, modelGroupId, version, description, isEnabled, rateLimiter, url, hashValue, modelFormat, modelConfig, deploySetting, deployModel, modelNodeIds.toArray(new String[0]), connector, connectorId, backendRoles, addAllBackendRoles, accessMode, doesVersionCreateModelGroup, isHidden, guardrails, modelInterface, tenantId);
    }

    public static MLRegisterModelInputBuilder builder() {
        return new MLRegisterModelInputBuilder();
    }

    public MLRegisterModelInputBuilder toBuilder() {
        return new MLRegisterModelInputBuilder().functionName(this.functionName).modelName(this.modelName).modelGroupId(this.modelGroupId).version(this.version).description(this.description).enabled(this.isEnabled).rateLimiter(this.rateLimiter).url(this.url).hashValue(this.hashValue).modelFormat(this.modelFormat).modelConfig(this.modelConfig).deploySetting(this.deploySetting).deployModel(this.deployModel).modelNodeIds(this.modelNodeIds).connector(this.connector).connectorId(this.connectorId).backendRoles(this.backendRoles).addAllBackendRoles(this.addAllBackendRoles).accessMode(this.accessMode).doesVersionCreateModelGroup(this.doesVersionCreateModelGroup).isHidden(this.isHidden).guardrails(this.guardrails).modelInterface(this.modelInterface).tenantId(this.tenantId);
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelGroupId() {
        return this.modelGroupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public MLRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    public MLDeploySetting getDeploySetting() {
        return this.deploySetting;
    }

    public boolean isDeployModel() {
        return this.deployModel;
    }

    public String[] getModelNodeIds() {
        return this.modelNodeIds;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public Boolean getAddAllBackendRoles() {
        return this.addAllBackendRoles;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Boolean getDoesVersionCreateModelGroup() {
        return this.doesVersionCreateModelGroup;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public Guardrails getGuardrails() {
        return this.guardrails;
    }

    public Map<String, String> getModelInterface() {
        return this.modelInterface;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setModelInterface(Map<String, String> modelInterface) {
        this.modelInterface = modelInterface;
    }

    public void setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setModelGroupId(String modelGroupId) {
        this.modelGroupId = modelGroupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setRateLimiter(MLRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public void setModelFormat(MLModelFormat modelFormat) {
        this.modelFormat = modelFormat;
    }

    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    public void setDeploySetting(MLDeploySetting deploySetting) {
        this.deploySetting = deploySetting;
    }

    public void setDeployModel(boolean deployModel) {
        this.deployModel = deployModel;
    }

    public void setModelNodeIds(String[] modelNodeIds) {
        this.modelNodeIds = modelNodeIds;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.addAllBackendRoles = addAllBackendRoles;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public void setDoesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
    }

    public void setIsHidden(Boolean hidden) {
        this.isHidden = hidden;
    }

    public void setGuardrails(Guardrails guardrails) {
        this.guardrails = guardrails;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public static class MLRegisterModelInputBuilder {
        private FunctionName functionName;
        private String modelName;
        private String modelGroupId;
        private String version;
        private String description;
        private Boolean isEnabled;
        private MLRateLimiter rateLimiter;
        private String url;
        private String hashValue;
        private MLModelFormat modelFormat;
        private MLModelConfig modelConfig;
        private MLDeploySetting deploySetting;
        private boolean deployModel;
        private String[] modelNodeIds;
        private Connector connector;
        private String connectorId;
        private List<String> backendRoles;
        private Boolean addAllBackendRoles;
        private AccessMode accessMode;
        private Boolean doesVersionCreateModelGroup;
        private Boolean isHidden;
        private Guardrails guardrails;
        private Map<String, String> modelInterface;
        private String tenantId;

        public MLRegisterModelInputBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        public MLRegisterModelInputBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MLRegisterModelInputBuilder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        public MLRegisterModelInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        public MLRegisterModelInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MLRegisterModelInputBuilder enabled(Boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public MLRegisterModelInputBuilder rateLimiter(MLRateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public MLRegisterModelInputBuilder url(String url) {
            this.url = url;
            return this;
        }

        public MLRegisterModelInputBuilder hashValue(String hashValue) {
            this.hashValue = hashValue;
            return this;
        }

        public MLRegisterModelInputBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        public MLRegisterModelInputBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        public MLRegisterModelInputBuilder deploySetting(MLDeploySetting deploySetting) {
            this.deploySetting = deploySetting;
            return this;
        }

        public MLRegisterModelInputBuilder deployModel(boolean deployModel) {
            this.deployModel = deployModel;
            return this;
        }

        public MLRegisterModelInputBuilder modelNodeIds(String[] modelNodeIds) {
            this.modelNodeIds = modelNodeIds;
            return this;
        }

        public MLRegisterModelInputBuilder connector(Connector connector) {
            this.connector = connector;
            return this;
        }

        public MLRegisterModelInputBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public MLRegisterModelInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public MLRegisterModelInputBuilder addAllBackendRoles(Boolean addAllBackendRoles) {
            this.addAllBackendRoles = addAllBackendRoles;
            return this;
        }

        public MLRegisterModelInputBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        public MLRegisterModelInputBuilder doesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
            this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
            return this;
        }

        public MLRegisterModelInputBuilder isHidden(Boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public MLRegisterModelInputBuilder guardrails(Guardrails guardrails) {
            this.guardrails = guardrails;
            return this;
        }

        public MLRegisterModelInputBuilder modelInterface(Map<String, String> modelInterface) {
            this.modelInterface = modelInterface;
            return this;
        }

        public MLRegisterModelInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLRegisterModelInput build() {
            return new MLRegisterModelInput(this.functionName, this.modelName, this.modelGroupId, this.version, this.description, this.isEnabled, this.rateLimiter, this.url, this.hashValue, this.modelFormat, this.modelConfig, this.deploySetting, this.deployModel, this.modelNodeIds, this.connector, this.connectorId, this.backendRoles, this.addAllBackendRoles, this.accessMode, this.doesVersionCreateModelGroup, this.isHidden, this.guardrails, this.modelInterface, this.tenantId);
        }
    }
}

