/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.undeploy;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class MLUndeployModelInput
implements ToXContentObject,
Writeable {
    private static final String MODEL_IDS_FIELD = "model_ids";
    private static final String NODE_IDS_FIELD = "node_ids";
    private String[] modelIds;
    private String[] nodeIds;

    public MLUndeployModelInput(StreamInput in) throws IOException {
        this.modelIds = in.readOptionalStringArray();
        this.nodeIds = in.readOptionalStringArray();
    }

    public MLUndeployModelInput(String[] modelIds, String[] nodeIds) {
        this.modelIds = modelIds;
        this.nodeIds = nodeIds;
    }

    public MLUndeployModelInput() {
    }

    public static MLUndeployModelInput parse(XContentParser parser) throws IOException {
        ArrayList<String> modelIds = new ArrayList<String>();
        ArrayList<String> nodeIds = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelIds.add(parser.text());
                    }
                    continue block8;
                }
                case "node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        nodeIds.add(parser.text());
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new MLUndeployModelInput(modelIds.toArray(new String[0]), nodeIds.toArray(new String[0]));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringArray(this.modelIds);
        out.writeOptionalStringArray(this.nodeIds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_IDS_FIELD, (Object)this.modelIds);
        builder.field(NODE_IDS_FIELD, (Object)this.nodeIds);
        builder.endObject();
        return builder;
    }

    public String[] getModelIds() {
        return this.modelIds;
    }

    public void setModelIds(String[] modelIds) {
        this.modelIds = modelIds;
    }

    public String[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(String[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLUndeployModelInput that = (MLUndeployModelInput)o;
        return Objects.deepEquals(this.modelIds, that.modelIds) && Objects.deepEquals(this.nodeIds, that.nodeIds);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.modelIds), Arrays.hashCode(this.nodeIds));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MLUndeployModelInput{modelIds=" + Arrays.toString(this.modelIds) + ", nodeIds=" + Arrays.toString(this.nodeIds) + "}";
    }

    public static class Builder {
        private String[] modelIds;
        private String[] nodeIds;

        public Builder modelIds(String[] modelIds) {
            this.modelIds = modelIds;
            return this;
        }

        public Builder nodeIds(String[] nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        public MLUndeployModelInput build() {
            return new MLUndeployModelInput(this.modelIds, this.nodeIds);
        }
    }
}

