/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.update_cache;

import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class MLUpdateModelCacheNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<String, String> modelUpdateStatus;

    public MLUpdateModelCacheNodeResponse(DiscoveryNode node, Map<String, String> modelUpdateStatus) {
        super(node);
        this.modelUpdateStatus = modelUpdateStatus;
    }

    public MLUpdateModelCacheNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelUpdateStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLUpdateModelCacheNodeResponse readStats(StreamInput in) throws IOException {
        return new MLUpdateModelCacheNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (!this.isModelUpdateStatusEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.modelUpdateStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (!this.isModelUpdateStatusEmpty()) {
            for (Map.Entry<String, String> stat : this.modelUpdateStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }

    public boolean isModelUpdateStatusEmpty() {
        return this.modelUpdateStatus == null || this.modelUpdateStatus.isEmpty();
    }

    public Map<String, String> getModelUpdateStatus() {
        return this.modelUpdateStatus;
    }
}

