/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.utils;

import io.skylite.common.SuppressForbidden;
import io.skylite.common.io.PathUtils;
import io.skylite.ml.common.exception.MLException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger log = LogManager.getLogger(FileUtils.class);

    @SuppressForbidden(reason="Needed for dependency removal")
    public static List<String> splitFileIntoChunks(Path filePath, Path outputPath, int chunkSize) throws IOException {
        Files.createDirectories(outputPath, new FileAttribute[0]);
        long fileSize = Files.size(filePath);
        ArrayList<String> nameList = new ArrayList<String>();
        try (SeekableByteChannel inChannel = Files.newByteChannel(filePath, StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
            int numberOfChunks = 0;
            long totalBytesRead = 0L;
            while (totalBytesRead < fileSize) {
                buffer.clear();
                int bytesRead = inChannel.read(buffer);
                if (bytesRead <= 0) {
                    break;
                }
                totalBytesRead += (long)bytesRead;
                buffer.flip();
                String partName = String.valueOf(numberOfChunks);
                Path partFilePath = outputPath.resolve(partName);
                try (SeekableByteChannel outChannel = Files.newByteChannel(partFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                    outChannel.write(buffer);
                }
                nameList.add(partFilePath.toString());
                ++numberOfChunks;
            }
        }
        return nameList;
    }

    @SuppressForbidden(reason="Dependency removal")
    public static void write(byte[] data, String destinationFile) throws IOException {
        Path filePath = PathUtils.get((String)destinationFile, (String[])new String[0]);
        FileUtils.write(data, filePath, false);
    }

    public static void write(byte[] data, Path destinationPath, boolean append) throws IOException {
        OpenOption[] openOptionArray;
        Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
        if (append) {
            OpenOption[] openOptionArray2 = new StandardOpenOption[2];
            openOptionArray2[0] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.APPEND;
        } else {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[2];
            standardOpenOptionArray[0] = StandardOpenOption.CREATE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[1] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        OpenOption[] options = openOptionArray;
        try (OutputStream outputStream = Files.newOutputStream(destinationPath, options);){
            outputStream.write(data);
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(Queue<Path> files, Path mergedFilePath) {
        log.debug("Merging {} files into {}", (Object)files.size(), (Object)mergedFilePath);
        boolean failed = false;
        try {
            Files.createDirectories(mergedFilePath.getParent(), new FileAttribute[0]);
            while (!files.isEmpty()) {
                Path filePath = files.poll();
                try {
                    byte[] fileContent = Files.readAllBytes(filePath);
                    FileUtils.write(fileContent, mergedFilePath, true);
                }
                catch (IOException e) {
                    log.error("Failed to merge file from {} to {}", (Object)filePath, (Object)mergedFilePath);
                    failed = true;
                }
                finally {
                    FileUtils.deleteFileQuietly(filePath);
                    if (!files.isEmpty()) continue;
                    FileUtils.deleteFileQuietly(filePath.getParent());
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to create merged file directory {}", (Object)mergedFilePath.getParent());
            failed = true;
        }
        if (failed) {
            FileUtils.deleteFileQuietly(mergedFilePath);
            throw new MLException("Failed to merge model chunks");
        }
    }

    @SuppressForbidden(reason="dependency removal")
    public static String calculateFileHash(Path path) throws IOException {
        String string;
        block9: {
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
                while (channel.read(buffer) != -1) {
                    buffer.flip();
                    digest.update(buffer);
                    buffer.clear();
                }
                byte[] hashBytes = digest.digest();
                string = HexFormat.of().formatHex(hashBytes);
                if (channel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("SHA-256 algorithm not available", e);
                }
            }
            channel.close();
        }
        return string;
    }

    public static void deleteFileQuietly(Path path) {
        AccessController.doPrivileged(() -> {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    FileUtils.deleteDirectoryQuietly(path);
                } else if (Files.isRegularFile(path, new LinkOption[0])) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                log.warn("Failed to delete file: {}", (Object)path);
            }
            return null;
        });
    }

    public static Set<String> getFileNames(Path ... paths) {
        HashSet<String> allFileNames = new HashSet<String>();
        for (Path path : paths) {
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path entry : stream) {
                    if (!Files.isRegularFile(entry, new LinkOption[0])) continue;
                    allFileNames.add(entry.getFileName().toString());
                }
            }
            catch (IOException e) {
                log.warn("Failed to read directory: {}", (Object)path);
            }
        }
        return allFileNames;
    }

    public static void deleteDirectory(Path directoryPath) throws IOException {
        if (Files.exists(directoryPath, new LinkOption[0])) {
            Files.walk(directoryPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete: " + String.valueOf(path), e);
                }
            });
        }
    }

    public static void deleteDirectoryQuietly(Path directoryPath) throws IOException {
        if (Files.exists(directoryPath, new LinkOption[0])) {
            Files.walk(directoryPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    log.warn("Failed to delete: " + String.valueOf(path), (Throwable)e);
                }
            });
        }
    }
}

