/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.skylite.core.common.Strings;
import io.skylite.ml.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexUtils {
    private static final Logger log = LogManager.getLogger(IndexUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Map<String, Object> DEFAULT_INDEX_SETTINGS = Map.of("index.number_of_shards", "1", "index.auto_expand_replicas", "0-1");
    public static final Map<String, Object> ALL_NODES_REPLICA_INDEX_SETTINGS = Map.of("index.number_of_shards", "1", "index.auto_expand_replicas", "0-all");
    public static final Map<String, Object> UPDATED_DEFAULT_INDEX_SETTINGS = Map.of("index.auto_expand_replicas", "0-1");
    public static final Map<String, Object> UPDATED_ALL_NODES_REPLICA_INDEX_SETTINGS = Map.of("index.auto_expand_replicas", "0-all");
    public static final String MAPPING_SCHEMA_PATH = "index-mappings/schema.json";
    private static final String USER_PLACEHOLDER = "USER_MAPPING_PLACEHOLDER";
    private static final String CONNECTOR_PLACEHOLDER = "CONNECTOR_MAPPING_PLACEHOLDER";
    public static final Map<String, String> MAPPING_PLACEHOLDERS = Map.of("USER_MAPPING_PLACEHOLDER", "index-mappings/placeholders/user.json", "CONNECTOR_MAPPING_PLACEHOLDER", "index-mappings/placeholders/connector.json");

    public static String getMappingFromFile(String path) throws IOException {
        String mapping = IndexUtils.readResourceAsString(path);
        if (mapping.isEmpty()) {
            throw new IllegalArgumentException("Empty mapping found at: " + path);
        }
        mapping = IndexUtils.replacePlaceholders(mapping);
        IndexUtils.validateMapping(mapping);
        return mapping;
    }

    private static String readResourceAsString(String path) throws IOException {
        InputStream stream = IndexUtils.class.getClassLoader().getResourceAsStream(path);
        if (stream == null) {
            throw new IOException("Resource not found: " + path);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static String replacePlaceholders(String mapping) throws IOException {
        if (mapping == null || mapping.isBlank()) {
            throw new IllegalArgumentException("Mapping cannot be null or empty");
        }
        HashMap<String, String> loadedPlaceholders = new HashMap<String, String>();
        for (Map.Entry<String, String> placeholder : MAPPING_PLACEHOLDERS.entrySet()) {
            loadedPlaceholders.put(placeholder.getKey(), IndexUtils.readResourceAsString(placeholder.getValue()));
        }
        StringBuilder result = new StringBuilder(mapping);
        for (Map.Entry entry : loadedPlaceholders.entrySet()) {
            int index;
            String placeholder = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            while ((index = result.indexOf(placeholder)) != -1) {
                result.replace(index, index + placeholder.length(), replacement);
            }
        }
        return result.toString();
    }

    public static void validateMapping(String mapping) throws IOException {
        if (mapping.isBlank() || !Strings.isJson((String)mapping)) {
            throw new IllegalArgumentException("Invalid or non-JSON mapping found: " + mapping);
        }
        String schema = IndexUtils.readResourceAsString(MAPPING_SCHEMA_PATH);
        StringUtils.validateSchema(schema, mapping);
    }

    public static Integer getVersionFromMapping(String mapping) {
        JsonNode metaNode;
        if (mapping == null || mapping.isBlank()) {
            throw new IllegalArgumentException("Mapping cannot be null or empty");
        }
        try {
            JsonNode mappingJson = OBJECT_MAPPER.readTree(mapping);
            if (mappingJson == null || !mappingJson.has("_meta")) {
                throw new JsonParseException("Failed to find \"_meta\" object in mapping: " + mapping);
            }
            if (!mappingJson.has("_meta")) {
                throw new IllegalArgumentException("Missing \"_meta\" in mapping: " + mapping);
            }
            metaNode = mappingJson.get("_meta");
            if (!metaNode.has("schema_version")) {
                throw new IllegalArgumentException("Missing \"schema_version\" in mapping: " + mapping);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid JSON structure in mapping", e);
        }
        try {
            return metaNode.get("schema_version").asInt();
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new RuntimeException("Invalid \"schema_version\" value in mapping: " + mapping, e);
        }
    }
}

