/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.hdfs;

import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.RepositoryPlugin;
import io.lucenia.repositories.hdfs.HdfsRepository;
import io.skylite.SpecialPermission;
import io.skylite.common.SuppressForbidden;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.env.Environment;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.Repository;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;

public final class HdfsPlugin
extends Plugin
implements RepositoryPlugin {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressForbidden(reason="Needs a security hack for hadoop on windows, until HADOOP-XXXX is fixed")
    private static Void evilHadoopInit() {
        Path hadoopHome;
        block11: {
            String oldValue;
            block10: {
                hadoopHome = null;
                oldValue = null;
                try {
                    hadoopHome = Files.createTempDirectory("hadoop", new FileAttribute[0]).toAbsolutePath();
                    oldValue = System.setProperty("hadoop.home.dir", hadoopHome.toString());
                    Class.forName("org.apache.hadoop.security.UserGroupInformation");
                    Class.forName("org.apache.hadoop.util.StringUtils");
                    Class.forName("org.apache.hadoop.util.ShutdownHookManager");
                    Class.forName("org.apache.hadoop.conf.Configuration");
                    if (oldValue != null) break block10;
                }
                catch (IOException | ClassNotFoundException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (oldValue == null) {
                            System.clearProperty("hadoop.home.dir");
                        } else {
                            System.setProperty("hadoop.home.dir", oldValue);
                        }
                        try {
                            if (hadoopHome == null) throw throwable;
                            Files.delete(hadoopHome);
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                System.clearProperty("hadoop.home.dir");
                break block11;
            }
            System.setProperty("hadoop.home.dir", oldValue);
        }
        try {
            if (hadoopHome == null) return null;
            Files.delete(hadoopHome);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Void eagerInit() {
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HdfsRepository.class.getClassLoader());
            KerberosInfo info = SecurityUtil.getKerberosInfo(ClientNamenodeProtocolPB.class, null);
            if (info == null) {
                throw new RuntimeException("Could not initialize SecurityUtil: Unable to find services for [org.apache.hadoop.security.SecurityInfo]");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        return null;
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("hdfs", metadata -> new HdfsRepository(metadata, env, namedXContentRegistry, clusterService, recoverySettings));
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(HdfsPlugin::evilHadoopInit);
        AccessController.doPrivileged(HdfsPlugin::eagerInit);
    }
}

