/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.search.pipeline.common.helpers;

import io.lucenia.search.pipeline.common.helpers.SearchRequestMapProcessingException;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SearchRequestMap
implements Map<String, Object> {
    private static final String UNSUPPORTED_OP_ERR = " Method not supported in Search pipeline script";
    private final SearchSourceBuilder source;

    public SearchRequestMap(SearchRequest searchRequest) {
        this.source = searchRequest.source();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size Method not supported in Search pipeline script");
    }

    @Override
    public boolean isEmpty() {
        return this.source == null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue Method not supported in Search pipeline script");
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        switch ((String)key) {
            case "from": {
                return this.source.from();
            }
            case "size": {
                return this.source.size();
            }
            case "explain": {
                return this.source.explain();
            }
            case "version": {
                return this.source.version();
            }
            case "seq_no_primary_term": {
                return this.source.seqNoAndPrimaryTerm();
            }
            case "track_scores": {
                return this.source.trackScores();
            }
            case "track_total_hits": {
                return this.source.trackTotalHitsUpTo();
            }
            case "min_score": {
                return this.source.minScore();
            }
            case "terminate_after": {
                return this.source.terminateAfter();
            }
            case "profile": {
                return this.source.profile();
            }
        }
        throw new SearchRequestMapProcessingException("Unsupported key: " + String.valueOf(key), new Object[0]);
    }

    @Override
    public Object put(String key, Object value) {
        Object originalValue = this.get(key);
        try {
            switch (key) {
                case "from": {
                    this.source.from(((Integer)value).intValue());
                    break;
                }
                case "size": {
                    this.source.size(((Integer)value).intValue());
                    break;
                }
                case "explain": {
                    this.source.explain((Boolean)value);
                    break;
                }
                case "version": {
                    this.source.version((Boolean)value);
                    break;
                }
                case "seq_no_primary_term": {
                    this.source.seqNoAndPrimaryTerm((Boolean)value);
                    break;
                }
                case "track_scores": {
                    this.source.trackScores(((Boolean)value).booleanValue());
                    break;
                }
                case "track_total_hits": {
                    this.source.trackTotalHitsUpTo(((Integer)value).intValue());
                    break;
                }
                case "min_score": {
                    this.source.minScore(((Float)value).floatValue());
                    break;
                }
                case "terminate_after": {
                    this.source.terminateAfter(((Integer)value).intValue());
                    break;
                }
                case "profile": {
                    this.source.profile(((Boolean)value).booleanValue());
                    break;
                }
                default: {
                    throw new SearchRequestMapProcessingException("Unsupported SearchRequest source property: " + key, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new SearchRequestMapProcessingException("Error while setting value for SearchRequest source property: " + key, e, new Object[0]);
        }
        return originalValue;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("remove Method not supported in Search pipeline script");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("putAll Method not supported in Search pipeline script");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear Method not supported in Search pipeline script");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("keySet Method not supported in Search pipeline script");
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("values Method not supported in Search pipeline script");
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException("entrySet Method not supported in Search pipeline script");
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        throw new UnsupportedOperationException("getOrDefault Method not supported in Search pipeline script");
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        throw new UnsupportedOperationException("forEach Method not supported in Search pipeline script");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        throw new UnsupportedOperationException("replaceAll Method not supported in Search pipeline script");
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnsupportedOperationException("putIfAbsent Method not supported in Search pipeline script");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("remove Method not supported in Search pipeline script");
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException("replace Method not supported in Search pipeline script");
    }

    @Override
    public Object replace(String key, Object value) {
        throw new UnsupportedOperationException("replace Method not supported in Search pipeline script");
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        throw new UnsupportedOperationException("computeIfAbsent Method not supported in Search pipeline script");
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        throw new UnsupportedOperationException("computeIfPresent Method not supported in Search pipeline script");
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        throw new UnsupportedOperationException("compute Method not supported in Search pipeline script");
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        throw new UnsupportedOperationException("merge Method not supported in Search pipeline script");
    }
}

