/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.rest.action;

import io.lucenia.jobscheduler.utils.JobDetailsService;
import io.lucenia.jobscheduler.utils.LockService;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.jobs.LockModel;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;

public class RestReleaseLockAction
extends BaseRestHandler {
    public static final String RELEASE_LOCK_ACTION = "release_lock_action";
    private final Logger logger = LogManager.getLogger(RestReleaseLockAction.class);
    private LockService lockService;

    public RestReleaseLockAction(LockService lockService) {
        this.lockService = lockService;
    }

    public String getName() {
        return RELEASE_LOCK_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_job_scheduler", "_release_lock", "lock_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        String lockId = restRequest.param("lock_id");
        if (lockId == null || lockId.isEmpty()) {
            throw new IOException("lockId cannot be null or empty");
        }
        CompletableFuture<Boolean> releaseLockInProgressFuture = new CompletableFuture<Boolean>();
        if (!this.lockService.lockIndexExist()) {
            releaseLockInProgressFuture.complete(false);
        } else {
            LockModel releaseLock;
            CompletableFuture findInProgressFuture = new CompletableFuture();
            this.lockService.findLock(lockId, (ActionListener<LockModel>)ActionListenerHelper.wrap(lock -> findInProgressFuture.complete(lock), exception -> {
                this.logger.error("Could not find lock model with lockId " + lockId, (Throwable)exception);
                findInProgressFuture.completeExceptionally((Throwable)exception);
            }));
            try {
                releaseLock = (LockModel)findInProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS).get();
            }
            catch (InterruptedException | CompletionException | ExecutionException e2) {
                if (e2.getCause() instanceof TimeoutException) {
                    this.logger.error(" Finding lock timed out ", (Throwable)e2);
                }
                if (e2.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e2.getCause();
                }
                if (e2.getCause() instanceof Error) {
                    throw (Error)e2.getCause();
                }
                throw new RuntimeException(e2.getCause());
            }
            if (releaseLock != null) {
                this.lockService.release(releaseLock, (ActionListener<Boolean>)ActionListenerHelper.wrap(response -> releaseLockInProgressFuture.complete((Boolean)response), e -> {
                    this.logger.error("Releasing lock failed with an exception", (Throwable)e);
                    releaseLockInProgressFuture.completeExceptionally((Throwable)e);
                }));
                try {
                    releaseLockInProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS);
                }
                catch (CompletionException e3) {
                    if (e3.getCause() instanceof TimeoutException) {
                        this.logger.error("Release lock timed out ", (Throwable)e3);
                    }
                    if (e3.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e3.getCause();
                    }
                    if (e3.getCause() instanceof Error) {
                        throw (Error)e3.getCause();
                    }
                    throw new RuntimeException(e3.getCause());
                }
            }
        }
        return channel -> {
            BytesRestResponse bytesRestResponse;
            boolean releaseResponse = false;
            try {
                releaseResponse = (Boolean)releaseLockInProgressFuture.get();
            }
            catch (Exception e) {
                this.logger.error("Exception occured in releasing lock ", (Throwable)e);
            }
            XContentBuilder builder = channel.newBuilder();
            RestStatus restStatus = RestStatus.OK;
            String restResponseString = releaseResponse ? "success" : "failed";
            try {
                builder.startObject();
                builder.field("release-lock", restResponseString);
                if (restResponseString.equals("failed")) {
                    restStatus = RestStatus.INTERNAL_SERVER_ERROR;
                }
                builder.endObject();
                bytesRestResponse = new BytesRestResponse(restStatus, builder);
            }
            finally {
                builder.close();
            }
            channel.sendResponse((RestResponse)bytesRestResponse);
        };
    }
}

