/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.transport;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class AcquireLockRequest
extends ActionRequest
implements ToXContentObject {
    private final String jobId;
    private final String jobIndexName;
    private final long lockDurationSeconds;
    public static final String JOB_ID = "job_id";
    public static final String JOB_INDEX_NAME = "job_index_name";
    public static final String LOCK_DURATION_SECONDS = "lock_duration_seconds";

    public AcquireLockRequest(String jobId, String jobIndexName, long lockDurationSeconds) {
        this.jobId = Objects.requireNonNull(jobId);
        this.jobIndexName = Objects.requireNonNull(jobIndexName);
        this.lockDurationSeconds = Objects.requireNonNull(lockDurationSeconds);
    }

    public AcquireLockRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = in.readString();
        this.jobIndexName = in.readString();
        this.lockDurationSeconds = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.jobId);
        out.writeString(this.jobIndexName);
        out.writeLong(this.lockDurationSeconds);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobIndexName() {
        return this.jobIndexName;
    }

    public long getLockDurationSeconds() {
        return this.lockDurationSeconds;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public static AcquireLockRequest parse(XContentParser parser) throws IOException {
        String jobId = null;
        String jobIndexName = null;
        Long lockDurationSeconds = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "job_id": {
                    jobId = parser.text();
                    continue block10;
                }
                case "job_index_name": {
                    jobIndexName = parser.text();
                    continue block10;
                }
                case "lock_duration_seconds": {
                    lockDurationSeconds = parser.longValue();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new AcquireLockRequest(jobId, jobIndexName, lockDurationSeconds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID, this.jobId);
        builder.field(JOB_INDEX_NAME, this.jobIndexName);
        builder.field(LOCK_DURATION_SECONDS, this.lockDurationSeconds);
        builder.endObject();
        return builder;
    }
}

