/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.join.aggregations;

import io.lucenia.join.aggregations.InternalChildren;
import io.lucenia.join.aggregations.ParentToChildrenAggregator;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.internal.SearchContext;

public class ChildrenAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Query parentFilter;
    private final Query childFilter;

    public ChildrenAggregatorFactory(String name, ValuesSourceConfig config, Query childFilter, Query parentFilter, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NonCollectingAggregator(this, this.name, searchContext, parent, this.factories, metadata){

            public InternalAggregation buildEmptyAggregation() {
                return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
            }
        };
    }

    protected Aggregator doCreateInternal(SearchExecutionContext searchExecutionContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        ValuesSource rawValuesSource = this.config.getValuesSource();
        if (!(rawValuesSource instanceof BytesValuesSource.WithOrdinals)) {
            throw new AggregationExecutionException("ValuesSource type " + rawValuesSource.toString() + "is not supported for aggregation " + this.name());
        }
        BytesValuesSource.WithOrdinals valuesSource = (BytesValuesSource.WithOrdinals)rawValuesSource;
        SearchContext searchContext = (SearchContext)searchExecutionContext;
        long maxOrd = valuesSource.globalMaxOrd((IndexSearcher)searchContext.searcher());
        return new ParentToChildrenAggregator(this.name, this.factories, searchContext, parent, this.childFilter, this.parentFilter, valuesSource, maxOrd, cardinality, metadata);
    }

    public String getStatsSubtype() {
        return "other";
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

