/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.http.netty4;

import io.lucenia.http.netty4.Netty4HttpChannel;
import io.lucenia.http.netty4.Netty4HttpServerTransport;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.http.HttpRequest;
import org.opensearch.http.HttpPipelinedRequest;

@ChannelHandler.Sharable
class Netty4HttpRequestHandler
extends SimpleChannelInboundHandler<HttpPipelinedRequest> {
    private final Netty4HttpServerTransport serverTransport;

    Netty4HttpRequestHandler(Netty4HttpServerTransport serverTransport) {
        this.serverTransport = serverTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpPipelinedRequest httpRequest) {
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        boolean success = false;
        try {
            this.serverTransport.incomingRequest((HttpRequest)httpRequest, channel);
            success = true;
        }
        finally {
            if (!success) {
                httpRequest.release();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        if (cause instanceof Error) {
            this.serverTransport.onException(channel, new Exception(cause));
        } else {
            this.serverTransport.onException(channel, (Exception)cause);
        }
    }
}

