/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.tribuo.Output;
import org.tribuo.clustering.protos.ClusterIDProto;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.OutputProto;

@ProtoSerializableClass(serializedDataClass=ClusterIDProto.class, version=0)
public class ClusterID
implements Output<ClusterID> {
    private static final long serialVersionUID = 1L;
    public static final int UNASSIGNED = -1;
    @ProtoSerializableField
    private final int id;
    @ProtoSerializableField
    private final double score;

    public ClusterID(int id) {
        this(id, Double.NaN);
    }

    public ClusterID(int id, double score) {
        this.id = id;
        this.score = score;
    }

    public static ClusterID deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ClusterIDProto proto = (ClusterIDProto)message.unpack(ClusterIDProto.class);
        ClusterID lbl = new ClusterID(proto.getId(), proto.getScore());
        return lbl;
    }

    public OutputProto serialize() {
        return (OutputProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    public double getScore() {
        return this.score;
    }

    public int getID() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterID)) {
            return false;
        }
        ClusterID that = (ClusterID)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean fullEquals(ClusterID o) {
        if (this == o) {
            return true;
        }
        if (!(Double.isNaN(o.score) && Double.isNaN(this.score) || Double.compare(o.score, this.score) == 0)) {
            return false;
        }
        return this.id == o.id;
    }

    public String toString() {
        if (Double.isNaN(this.score)) {
            return "" + this.id;
        }
        return "(" + this.id + "," + this.score + ")";
    }

    public ClusterID copy() {
        return new ClusterID(this.id, this.score);
    }

    public String getSerializableForm(boolean includeConfidence) {
        if (includeConfidence && !Double.isNaN(this.score)) {
            return this.id + ",score=" + this.score;
        }
        return "" + this.id;
    }
}

