/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.evaluation;

import java.util.List;
import java.util.function.BiFunction;
import org.tribuo.clustering.ClusterID;
import org.tribuo.clustering.evaluation.ClusteringMetric;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.util.infotheory.InformationTheory;

public enum ClusteringMetrics {
    NORMALIZED_MI((target, context) -> ClusteringMetrics.normalizedMI(context)),
    ADJUSTED_MI((target, context) -> ClusteringMetrics.adjustedMI(context));

    private final BiFunction<MetricTarget<ClusterID>, ClusteringMetric.Context, Double> impl;

    private ClusteringMetrics(BiFunction<MetricTarget<ClusterID>, ClusteringMetric.Context, Double> impl) {
        this.impl = impl;
    }

    public BiFunction<MetricTarget<ClusterID>, ClusteringMetric.Context, Double> getImpl() {
        return this.impl;
    }

    public ClusteringMetric forTarget(MetricTarget<ClusterID> tgt) {
        return new ClusteringMetric(tgt, this.name(), this.getImpl());
    }

    public static double adjustedMI(ClusteringMetric.Context context) {
        return ClusteringMetrics.adjustedMI(context.getPredictedIDs(), context.getTrueIDs());
    }

    public static double adjustedMI(List<Integer> predictedIDs, List<Integer> trueIDs) {
        double mi = InformationTheory.mi(predictedIDs, trueIDs);
        double predEntropy = InformationTheory.entropy(predictedIDs);
        double trueEntropy = InformationTheory.entropy(trueIDs);
        double expectedMI = InformationTheory.expectedMI(trueIDs, predictedIDs);
        double minEntropy = Math.min(predEntropy, trueEntropy);
        double denominator = minEntropy - expectedMI;
        denominator = denominator < 0.0 ? Math.min(denominator, -2.220446049250313E-16) : Math.max(denominator, 2.220446049250313E-16);
        return (mi - expectedMI) / denominator;
    }

    public static double normalizedMI(ClusteringMetric.Context context) {
        double trueEntropy;
        double mi = InformationTheory.mi(context.getPredictedIDs(), context.getTrueIDs());
        double predEntropy = InformationTheory.entropy(context.getPredictedIDs());
        return predEntropy < (trueEntropy = InformationTheory.entropy(context.getTrueIDs())) ? mi / predEntropy : mi / trueEntropy;
    }
}

