/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client;

import io.lucenia.client.Request;
import io.lucenia.client.RequestConverters;
import io.skylite.core.action.ingest.DeletePipelineRequest;
import io.skylite.core.action.ingest.GetPipelineRequest;
import io.skylite.core.action.ingest.PutPipelineRequest;
import io.skylite.core.action.ingest.SimulatePipelineRequest;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;

final class IngestRequestConverters {
    private IngestRequestConverters() {
    }

    static Request getPipeline(GetPipelineRequest getPipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addCommaSeparatedPathParts(getPipelineRequest.getIds()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withClusterManagerTimeout(getPipelineRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request putPipeline(PutPipelineRequest putPipelineRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addPathPart(putPipelineRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(putPipelineRequest.timeout());
        parameters.withClusterManagerTimeout(putPipelineRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)putPipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addPathPart(deletePipelineRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(deletePipelineRequest.timeout());
        parameters.withClusterManagerTimeout(deletePipelineRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request simulatePipeline(SimulatePipelineRequest simulatePipelineRequest) throws IOException {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline");
        if (simulatePipelineRequest.getId() != null && !simulatePipelineRequest.getId().isEmpty()) {
            builder.addPathPart(simulatePipelineRequest.getId());
        }
        builder.addPathPartAsIs("_simulate");
        String endpoint = builder.build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.putParam("verbose", Boolean.toString(simulatePipelineRequest.isVerbose()));
        request.addParameters(params.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)simulatePipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

