/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.indices.rollover;

import io.lucenia.client.TimedRequest;
import io.lucenia.client.indices.CreateIndexRequest;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.rollover.Condition;
import io.skylite.core.action.admin.indices.rollover.MaxAgeCondition;
import io.skylite.core.action.admin.indices.rollover.MaxDocsCondition;
import io.skylite.core.action.admin.indices.rollover.MaxSizeCondition;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RolloverRequest
extends TimedRequest
implements ToXContentObject {
    private final String alias;
    private final String newIndexName;
    private boolean dryRun;
    private final Map<String, Condition<?>> conditions = new HashMap(2);
    private final CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");

    public RolloverRequest(String alias, String newIndexName) {
        if (alias == null) {
            throw new IllegalArgumentException("The index alias cannot be null!");
        }
        this.alias = alias;
        this.newIndexName = newIndexName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNewIndexName() {
        return this.newIndexName;
    }

    public RolloverRequest dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public RolloverRequest addMaxIndexAgeCondition(TimeValue age) {
        MaxAgeCondition maxAgeCondition = new MaxAgeCondition(age);
        if (this.conditions.containsKey(maxAgeCondition.name())) {
            throw new IllegalArgumentException(maxAgeCondition.name() + " condition is already set");
        }
        this.conditions.put(maxAgeCondition.name(), (Condition<?>)maxAgeCondition);
        return this;
    }

    public RolloverRequest addMaxIndexDocsCondition(long numDocs) {
        MaxDocsCondition maxDocsCondition = new MaxDocsCondition(Long.valueOf(numDocs));
        if (this.conditions.containsKey(maxDocsCondition.name())) {
            throw new IllegalArgumentException(maxDocsCondition.name() + " condition is already set");
        }
        this.conditions.put(maxDocsCondition.name(), (Condition<?>)maxDocsCondition);
        return this;
    }

    public RolloverRequest addMaxIndexSizeCondition(ByteSizeValue size) {
        MaxSizeCondition maxSizeCondition = new MaxSizeCondition(size);
        if (this.conditions.containsKey(maxSizeCondition.name())) {
            throw new IllegalArgumentException(String.valueOf(maxSizeCondition) + " condition is already set");
        }
        this.conditions.put(maxSizeCondition.name(), (Condition<?>)maxSizeCondition);
        return this;
    }

    public Map<String, Condition<?>> getConditions() {
        return this.conditions;
    }

    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.createIndexRequest.innerToXContent(builder, params);
        builder.startObject("conditions");
        for (Condition<?> condition : this.conditions.values()) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

