/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.license;

import io.lucenia.license.ILuceniaLicense;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Base16;
import org.apache.commons.collections4.ListUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LuceniaLicense
implements ILuceniaLicense {
    private static final Logger logger = LogManager.getLogger(LuceniaLicense.class);
    private static final String LICENSE_SERVER_URL = "https://cloud.lucenia.io/check/v1";
    static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String BEGIN_LICENSE_CERTIFICATE = "--------BEGIN LICENSE CERTIFICATE-------";
    public static final String END_LICENSE_CERTIFICATE = "--------END LICENSE CERTIFICATE---------";
    static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    private static final Base16 base16 = new Base16(false);
    private final UUID id;
    private final String type;
    private final String licensee;
    private final Date expiration;
    private final int resourceUnits;

    private String licenseMetricToString(LICENSE_METRIC metric) {
        switch (metric.ordinal()) {
            case 0: {
                return "max_heap";
            }
            case 1: {
                return "node_cnt";
            }
        }
        return "";
    }

    public LuceniaLicense(UUID id, String type, String licensee, Date expiration) {
        this.id = id;
        this.type = type;
        this.licensee = licensee;
        this.expiration = expiration;
        this.resourceUnits = 1;
    }

    public LuceniaLicense(UUID id, String type, String licensee, Date expiration, int resourceUnits) {
        this.id = id;
        this.type = type;
        this.licensee = licensee;
        this.expiration = expiration;
        this.resourceUnits = resourceUnits;
    }

    @Override
    public String id() {
        return this.id.toString();
    }

    public URI getURI() {
        return URI.create("https://cloud.lucenia.io/check/v1/license/verify");
    }

    @Override
    public int getResourceUnits() {
        return this.resourceUnits;
    }

    public boolean verifyRemoteRequest(CloseableHttpAsyncClient httpClient, String json) {
        try {
            URI uri = this.getURI();
            SimpleHttpRequest shr = SimpleHttpRequest.create((Method)Method.POST, (URI)uri);
            shr.setBody(json, ContentType.APPLICATION_JSON);
            Future response = AccessController.doPrivileged(() -> httpClient.execute(shr, (FutureCallback)new FutureCallback<SimpleHttpResponse>(this){

                public void completed(SimpleHttpResponse result) {
                }

                public void failed(Exception ex) {
                    throw new RuntimeException("License server http call failed", ex);
                }

                public void cancelled() {
                    throw new RuntimeException("License server exception; verify remote cancelled was called");
                }
            }));
            SimpleHttpResponse resp = AccessController.doPrivileged(() -> {
                try {
                    return (SimpleHttpResponse)response.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("License server exception; verify remote failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            if (resp.getCode() == 200) {
                logger.info("Lucenia License - license is valid");
                return true;
            }
            if (resp.getCode() == 404) {
                logger.error("Lucenia License - license not found");
            } else {
                String text = resp.getBodyText();
                logger.error("Lucenia License - license is not valid: {}", (Object)text);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean verifyRemote(CloseableHttpAsyncClient httpClient, String clusterId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    String text() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calendar.setTime(this.expiration);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        return "ID: " + String.valueOf(this.id) + "\nType: " + this.type + "\nLicensee: " + this.licensee + "\nExpiry: " + sdf.format(this.expiration);
    }

    public String block(String signature) {
        List chunks = IntStream.range(0, signature.length() / 8).mapToObj(i -> signature.substring(i * 8, (i + 1) * 8)).collect(Collectors.toList());
        List partitions = ListUtils.partition(chunks, (int)4);
        return partitions.stream().map(partition -> String.join((CharSequence)" ", partition)).collect(Collectors.joining("\n"));
    }

    public String signature(String block) {
        return block.replaceAll("\n", "").replaceAll(" ", "");
    }

    public String toString() {
        return String.format(Locale.ROOT, "--------BEGIN LICENSE CERTIFICATE-------\\n%s\\n\\n%s\\n--------END LICENSE CERTIFICATE---------\\n", this.text(), this.block("signature"));
    }

    @Override
    public boolean isExpired() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calendar.add(6, 1);
        Date tomorrow = calendar.getTime();
        return this.expiration.before(tomorrow);
    }

    static String[] parts(String certificate) {
        String[] parts = certificate.trim().replaceAll("--------BEGIN LICENSE CERTIFICATE-------\n", "").replaceAll(END_LICENSE_CERTIFICATE, "").split("\n\n");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid certificate");
        }
        return parts;
    }

    public boolean verify(String publicKey, String certificate) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, InvalidKeyException {
        String[] parts = LuceniaLicense.parts(certificate);
        return this.verify(publicKey, parts[0], this.signature(parts[1]));
    }

    public boolean verify(String publicKey, String text, String signature) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, UnsupportedEncodingException, SignatureException {
        String strippedPublicKey = publicKey.replaceAll(BEGIN_PUBLIC_KEY, "").replaceAll(END_PUBLIC_KEY, "").replaceAll("\n", "");
        byte[] keyBytes = Base64.getDecoder().decode(strippedPublicKey);
        Signature instance = Signature.getInstance("SHA256withRSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        instance.initVerify(keyFactory.generatePublic(keySpec));
        instance.update(text.getBytes(StandardCharsets.UTF_8));
        return instance.verify(base16.decode(signature));
    }

    @Override
    public boolean verifySignature(String certificate) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, InvalidKeyException {
        String publicKey = "-----BEGIN PUBLIC KEY-----\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCaTYbBopOC/EPhWwXpL2HKF7V3\n+c20kdFLJK7WBZVuZWeqxUSlz2CtpLjapfh5e2d/Gegd+8UN0UKdT+ANgDAzU8CW\nQcTXPkXgoi3d7JWcjP+hyA2/oVNw7kayD+XWX/RbPpe+QaWXjmlGw+gTLzijR6U0\nsG4zlfegdJ2NwbthGwIDAQAB\n-----END PUBLIC KEY-----\n";
        return this.verify(publicKey, certificate);
    }

    protected String createResourceLicenseCheckJSON(String clusterId, String nodeId, LICENSE_METRIC metric, int quantity) {
        return "{\"cluster_id\":\"" + clusterId + "\",\"node_id\":\"" + nodeId + "\",\"license_id\":\"" + this.id() + "\",\"metric\":\"" + this.licenseMetricToString(metric) + "\",\"quantity\":" + quantity + "}";
    }

    protected static enum LICENSE_METRIC {
        MAX_HEAP,
        NODE_CNT;

    }
}

