/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.license.task;

import io.lucenia.license.ILuceniaLicense;
import io.lucenia.license.ILuceniaResourceUnitLicense;
import io.lucenia.license.LuceniaLicenseFactory;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.persistent.AllocatedPersistentTask;

public class LuceniaLicenseChecker
extends AllocatedPersistentTask {
    private static final Logger logger = LogManager.getLogger(LuceniaLicenseChecker.class);
    private static final int MAX_LICENSE_CHECK_RETRIES = 5;
    private static final TimeValue RETRY_DELAY = TimeValue.timeValueSeconds((long)5L);
    private final Supplier<TimeValue> pollInterval;
    private final ThreadPool threadPool;
    private final String executorName;
    private volatile Scheduler.ScheduledCancellable scheduled;
    private final String licenseCertificate;
    private final CloseableHttpAsyncClient httpClient;
    private String clusterId;
    private ClusterService clusterService = null;
    private ILuceniaLicense license;

    LuceniaLicenseChecker(long id, String type, String action, String description, TaskId parentTaskId, String executorName, Supplier<TimeValue> pollInterval, ThreadPool threadPool, CloseableHttpAsyncClient httpClient, Map<String, String> headers, String licenseCertificate, String clusterId) {
        super(id, type, action, description, parentTaskId, headers);
        this.pollInterval = pollInterval;
        this.threadPool = threadPool;
        this.licenseCertificate = licenseCertificate;
        this.executorName = executorName;
        this.httpClient = httpClient;
        this.clusterId = clusterId;
    }

    boolean checkLicense() {
        logger.info("Checking license");
        if (this.licenseCertificate == null) {
            logger.error("License certificate is null");
            return false;
        }
        try {
            this.license = LuceniaLicenseFactory.parse(this.licenseCertificate);
            if (!this.license.verifySignature(this.licenseCertificate)) {
                logger.error("License certificate is not verified");
                return false;
            }
        }
        catch (Exception e) {
            logger.error("License certificate is not valid", (Throwable)e);
            return false;
        }
        if (this.license.isExpired()) {
            String msg = "License is expired. Please contact Lucenia support to renew your license. License ID:" + this.license.id();
            logger.error(msg);
            return false;
        }
        if (this.license.hasNodeLimit()) {
            if (this.license.getNodeLimit() < 1) {
                String msg = "License has an invalid node limit. Please contact Lucenia support to renew your license. License ID:" + this.license.id();
                logger.error(msg);
                return false;
            }
            int nodeCount = this.clusterService.state().nodes().getSize();
            if (nodeCount > this.license.getNodeLimit()) {
                logger.error("Cluster has exceeded the node limit of " + this.license.getNodeLimit() + " with " + nodeCount + " nodes. Please contact Lucenia support to renew your license. License ID:" + this.license.id());
                return false;
            }
        }
        if (this.license instanceof ILuceniaResourceUnitLicense) {
            ILuceniaResourceUnitLicense resourceUnitLicense = (ILuceniaResourceUnitLicense)((Object)this.license);
            JvmInfo jvmInfo = this.clusterService.getJvmInfo();
            int maxHeap = (int)jvmInfo.getMem().getHeapMax().getMb() * this.clusterService.state().getNodes().getSize();
            if (!resourceUnitLicense.verifyRemote(this.httpClient, this.clusterId, this.clusterService.state().nodes().getLocalNode().getId(), maxHeap)) {
                logger.error("Lucenia License Checker - license is not valid");
                return false;
            }
        } else if (!this.license.verifyRemote(this.httpClient, this.clusterId)) {
            logger.info("Lucenia License Checker - license is not valid");
            return false;
        }
        logger.info("Lucenia License Checker - license is valid");
        return true;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    private void runLicenseChecker() {
        if (this.isCancelled() || this.isCompleted()) {
            return;
        }
        this.runLicenseCheckerWithRetries(1);
    }

    private void runLicenseCheckerWithRetries(int attemptNumber) {
        if (this.isCancelled() || this.isCompleted()) {
            return;
        }
        logger.info("License check attempt {} of {}", (Object)attemptNumber, (Object)5);
        if (this.checkLicense()) {
            logger.info("License validation successful on attempt {}", (Object)attemptNumber);
            this.scheduleNextCheck(this.pollInterval.get());
        } else if (attemptNumber < 5) {
            logger.warn("License validation failed on attempt {} of {}. Retrying in {} seconds...", (Object)attemptNumber, (Object)5, (Object)RETRY_DELAY.seconds());
            if (!this.threadPool.scheduler().isShutdown()) {
                this.scheduled = this.threadPool.schedule(() -> this.runLicenseCheckerWithRetries(attemptNumber + 1), RETRY_DELAY, this.executorName);
            }
        } else {
            logger.error("License validation failed after {} attempts. Stopping the cluster.", (Object)5);
            this.stop();
        }
    }

    void startLicenseChecker() {
        this.scheduleNextCheck(this.pollInterval.get());
    }

    void stop() {
        logger.error("Stopping the cluster due to invalid license");
        if (this.clusterService != null) {
            this.clusterService.stop();
        }
    }

    private void scheduleNextCheck(TimeValue delay) {
        if (!this.threadPool.scheduler().isShutdown()) {
            logger.info("Rescheduling license check in [{}]", (Object)delay.getStringRep());
            this.scheduled = this.threadPool.schedule(this::runLicenseChecker, delay, this.executorName);
        }
    }

    protected void onCancelled() {
        if (this.scheduled != null) {
            this.scheduled.cancel();
        }
        this.markAsCompleted();
    }
}

