/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.action;

import io.lucenia.painless.action.PainlessContextConstructorInfo;
import io.lucenia.painless.action.PainlessContextFieldInfo;
import io.lucenia.painless.action.PainlessContextMethodInfo;
import io.lucenia.painless.lookup.PainlessClass;
import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PainlessContextClassInfo
implements Writeable,
ToXContentObject {
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField IMPORTED = new ParseField("imported", new String[0]);
    public static final ParseField CONSTRUCTORS = new ParseField("constructors", new String[0]);
    public static final ParseField STATIC_METHODS = new ParseField("static_methods", new String[0]);
    public static final ParseField METHODS = new ParseField("methods", new String[0]);
    public static final ParseField STATIC_FIELDS = new ParseField("static_fields", new String[0]);
    public static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final ConstructingObjectParser<PainlessContextClassInfo, Void> PARSER = new ConstructingObjectParser(PainlessContextClassInfo.class.getCanonicalName(), v -> new PainlessContextClassInfo((String)v[0], (Boolean)v[1], (List)v[2], (List)v[3], (List)v[4], (List)v[5], (List)v[6]));
    private final String name;
    private final boolean imported;
    private final List<PainlessContextConstructorInfo> constructors;
    private final List<PainlessContextMethodInfo> staticMethods;
    private final List<PainlessContextMethodInfo> methods;
    private final List<PainlessContextFieldInfo> staticFields;
    private final List<PainlessContextFieldInfo> fields;

    public PainlessContextClassInfo(Class<?> javaClass, boolean imported, PainlessClass painlessClass) {
        this(javaClass.getName(), imported, painlessClass.constructors.values().stream().map(PainlessContextConstructorInfo::new).collect(Collectors.toList()), painlessClass.staticMethods.values().stream().map(PainlessContextMethodInfo::new).collect(Collectors.toList()), painlessClass.methods.values().stream().map(PainlessContextMethodInfo::new).collect(Collectors.toList()), painlessClass.staticFields.values().stream().map(PainlessContextFieldInfo::new).collect(Collectors.toList()), painlessClass.fields.values().stream().map(PainlessContextFieldInfo::new).collect(Collectors.toList()));
    }

    public PainlessContextClassInfo(String name, boolean imported, List<PainlessContextConstructorInfo> constructors, List<PainlessContextMethodInfo> staticMethods, List<PainlessContextMethodInfo> methods, List<PainlessContextFieldInfo> staticFields, List<PainlessContextFieldInfo> fields) {
        this.name = Objects.requireNonNull(name);
        this.imported = imported;
        constructors = new ArrayList<PainlessContextConstructorInfo>((Collection)Objects.requireNonNull(constructors));
        constructors.sort(Comparator.comparing(PainlessContextConstructorInfo::getSortValue));
        this.constructors = Collections.unmodifiableList(constructors);
        staticMethods = new ArrayList<PainlessContextMethodInfo>((Collection)Objects.requireNonNull(staticMethods));
        staticMethods.sort(Comparator.comparing(PainlessContextMethodInfo::getSortValue));
        this.staticMethods = Collections.unmodifiableList(staticMethods);
        methods = new ArrayList<PainlessContextMethodInfo>((Collection)Objects.requireNonNull(methods));
        methods.sort(Comparator.comparing(PainlessContextMethodInfo::getSortValue));
        this.methods = Collections.unmodifiableList(methods);
        staticFields = new ArrayList<PainlessContextFieldInfo>((Collection)Objects.requireNonNull(staticFields));
        staticFields.sort(Comparator.comparing(PainlessContextFieldInfo::getSortValue));
        this.staticFields = Collections.unmodifiableList(staticFields);
        fields = new ArrayList<PainlessContextFieldInfo>((Collection)Objects.requireNonNull(fields));
        fields.sort(Comparator.comparing(PainlessContextFieldInfo::getSortValue));
        this.fields = Collections.unmodifiableList(fields);
    }

    public PainlessContextClassInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.imported = in.readBoolean();
        this.constructors = Collections.unmodifiableList(in.readList(PainlessContextConstructorInfo::new));
        this.staticMethods = Collections.unmodifiableList(in.readList(PainlessContextMethodInfo::new));
        this.methods = Collections.unmodifiableList(in.readList(PainlessContextMethodInfo::new));
        this.staticFields = Collections.unmodifiableList(in.readList(PainlessContextFieldInfo::new));
        this.fields = Collections.unmodifiableList(in.readList(PainlessContextFieldInfo::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.imported);
        out.writeList(this.constructors);
        out.writeList(this.staticMethods);
        out.writeList(this.methods);
        out.writeList(this.staticFields);
        out.writeList(this.fields);
    }

    public static PainlessContextClassInfo fromXContent(XContentParser parser) {
        return (PainlessContextClassInfo)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(IMPORTED.getPreferredName(), this.imported);
        builder.field(CONSTRUCTORS.getPreferredName(), this.constructors);
        builder.field(STATIC_METHODS.getPreferredName(), this.staticMethods);
        builder.field(METHODS.getPreferredName(), this.methods);
        builder.field(STATIC_FIELDS.getPreferredName(), this.staticFields);
        builder.field(FIELDS.getPreferredName(), this.fields);
        builder.endObject();
        return builder;
    }

    public String getSortValue() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PainlessContextClassInfo that = (PainlessContextClassInfo)o;
        return this.imported == that.imported && Objects.equals(this.name, that.name) && Objects.equals(this.constructors, that.constructors) && Objects.equals(this.staticMethods, that.staticMethods) && Objects.equals(this.methods, that.methods) && Objects.equals(this.staticFields, that.staticFields) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imported, this.constructors, this.staticMethods, this.methods, this.staticFields, this.fields);
    }

    public String toString() {
        return "PainlessContextClassInfo{name='" + this.name + "', imported=" + this.imported + ", constructors=" + String.valueOf(this.constructors) + ", staticMethods=" + String.valueOf(this.staticMethods) + ", methods=" + String.valueOf(this.methods) + ", staticFields=" + String.valueOf(this.staticFields) + ", fields=" + String.valueOf(this.fields) + "}";
    }

    public String getName() {
        return this.name;
    }

    public boolean isImported() {
        return this.imported;
    }

    public List<PainlessContextConstructorInfo> getConstructors() {
        return this.constructors;
    }

    public List<PainlessContextMethodInfo> getStaticMethods() {
        return this.staticMethods;
    }

    public List<PainlessContextMethodInfo> getMethods() {
        return this.methods;
    }

    public List<PainlessContextFieldInfo> getStaticFields() {
        return this.staticFields;
    }

    public List<PainlessContextFieldInfo> getFields() {
        return this.fields;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), IMPORTED);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextConstructorInfo.fromXContent(p), CONSTRUCTORS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextMethodInfo.fromXContent(p), STATIC_METHODS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextMethodInfo.fromXContent(p), METHODS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextFieldInfo.fromXContent(p), STATIC_FIELDS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextFieldInfo.fromXContent(p), FIELDS);
    }
}

