/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.Operation;
import io.lucenia.painless.ir.BinaryNode;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class BooleanNode
extends BinaryNode {
    private Operation operation;

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitBoolean(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getLeftNode().visit(irTreeVisitor, scope);
        this.getRightNode().visit(irTreeVisitor, scope);
    }

    public BooleanNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.operation == Operation.AND) {
            Label fals = new Label();
            Label end = new Label();
            this.getLeftNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            this.getRightNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else if (this.operation == Operation.OR) {
            Label tru = new Label();
            Label fals = new Label();
            Label end = new Label();
            this.getLeftNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(154, tru);
            this.getRightNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.mark(tru);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else {
            throw new IllegalStateException("unexpected boolean operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
        }
    }
}

