/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.ir.BlockNode;
import io.lucenia.painless.ir.StatementNode;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class CatchNode
extends StatementNode {
    private Class<?> exceptionType;
    private String symbol;
    private BlockNode blockNode;
    Label begin = null;
    Label end = null;
    Label exception = null;

    public void setExceptionType(Class<?> exceptionType) {
        this.exceptionType = exceptionType;
    }

    public Class<?> getExceptionType() {
        return this.exceptionType;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setBlockNode(BlockNode blockNode) {
        this.blockNode = blockNode;
    }

    public BlockNode getBlockNode() {
        return this.blockNode;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitCatch(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        if (this.blockNode != null) {
            this.blockNode.visit(irTreeVisitor, scope);
        }
    }

    public CatchNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeStatementOffset(this.getLocation());
        WriteScope.Variable variable = writeScope.defineVariable(this.exceptionType, this.symbol);
        Label jump = new Label();
        methodWriter.mark(jump);
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
        if (this.blockNode != null) {
            this.blockNode.continueLabel = this.continueLabel;
            this.blockNode.breakLabel = this.breakLabel;
            this.blockNode.write(classWriter, methodWriter, writeScope);
        }
        methodWriter.visitTryCatchBlock(this.begin, this.end, jump, variable.getAsmType().getInternalName());
        if (!(this.exception == null || this.blockNode != null && this.blockNode.doAllEscape())) {
            methodWriter.goTo(this.exception);
        }
    }
}

