/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.ir.ExpressionNode;
import io.lucenia.painless.ir.StatementNode;
import io.lucenia.painless.lookup.PainlessLookupUtility;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;

public class DeclarationNode
extends StatementNode {
    private ExpressionNode expressionNode;
    protected String name;
    protected Class<?> declarationType;

    public void setExpressionNode(ExpressionNode expressionNode) {
        this.expressionNode = expressionNode;
    }

    public ExpressionNode getExpressionNode() {
        return this.expressionNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDeclarationType(Class<?> declarationType) {
        this.declarationType = declarationType;
    }

    public Class<?> getDeclarationType() {
        return this.declarationType;
    }

    public String getDeclarationCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.declarationType);
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitDeclaration(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        if (this.expressionNode != null) {
            this.expressionNode.visit(irTreeVisitor, scope);
        }
    }

    public DeclarationNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeStatementOffset(this.getLocation());
        WriteScope.Variable variable = writeScope.defineVariable(this.declarationType, this.name);
        if (this.expressionNode == null) {
            Class<?> sort = variable.getType();
            if (sort == Void.TYPE || sort == Boolean.TYPE || sort == Byte.TYPE || sort == Short.TYPE || sort == Character.TYPE || sort == Integer.TYPE) {
                methodWriter.push(0);
            } else if (sort == Long.TYPE) {
                methodWriter.push(0L);
            } else if (sort == Float.TYPE) {
                methodWriter.push(0.0f);
            } else if (sort == Double.TYPE) {
                methodWriter.push(0.0);
            } else {
                methodWriter.visitInsn(1);
            }
        } else {
            this.expressionNode.write(classWriter, methodWriter, writeScope);
        }
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
    }
}

